/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQueryHeader;
import org.eclipse.incquery.tooling.ui.retevis.ReteVisualization;
import org.eclipse.incquery.tooling.ui.retevis.views.ReteVisualizationViewSupport;
import org.eclipse.incquery.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class ReteVisualizationView
extends ViewPart
implements IZoomableWorkbenchPart {
    private GraphViewer graphViewer;
    private ReteVisualizationViewSupport viewSupport;

    public void createPartControl(Composite parent) {
        this.graphViewer = new GraphViewer(parent, 2048);
        HashSet queryNames = Sets.newHashSet();
        try {
            for (PQueryHeader query : ReteVisualization.instance().getSpecifications()) {
                queryNames.add(query.getFullyQualifiedName());
            }
        }
        catch (IncQueryException e) {
            throw new RuntimeException("Failed to get Rete Visualization query specifications", e);
        }
        this.viewSupport = new ReteVisualizationViewSupport((IViewPart)this, ViewersComponentConfiguration.fromQuerySpecFQNs((Collection)queryNames), this.graphViewer);
        this.viewSupport.createPartControl(parent, this.graphViewer.getControl());
        this.viewSupport.createToolbar();
        this.viewSupport.createLayoutMenu();
    }

    public void dispose() {
        this.viewSupport.dispose();
        super.dispose();
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.graphViewer;
    }

    public void setFocus() {
    }
}

