/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.boundary.unused;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.rete.boundary.Disconnectable;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.index.IdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.NullIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.StandardNode;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class EStructuralFeatureBinaryInputNode
extends StandardNode
implements Disconnectable {
    private EStructuralFeature feature;
    private IncQueryEngine engine;
    private NavigationHelper baseIndex;
    private ReteEngine<Pattern> reteEngine;
    private ReteBoundary<Pattern> boundary;
    static final TupleMask nullMask = TupleMask.linear((int)0, (int)2);
    static final TupleMask sourceKnown = TupleMask.selectSingle((int)0, (int)2);
    static final TupleMask targetKnown = TupleMask.selectSingle((int)1, (int)2);
    static final TupleMask identityMask = TupleMask.identity((int)2);
    private NullIndexer nullIndexer;
    private IdentityIndexer identityIndexer;
    private ProjectionIndexer sourceIndexer;
    private ProjectionIndexer targetIndexer;
    private FeatureListener listener = new FeatureListener(){

        public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
            Tuple tuple = EStructuralFeatureBinaryInputNode.this.makeTuple(host, value);
            EStructuralFeatureBinaryInputNode.this.propagate(Direction.INSERT, tuple);
        }

        public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
            Tuple tuple = EStructuralFeatureBinaryInputNode.this.makeTuple(host, value);
            EStructuralFeatureBinaryInputNode.this.propagate(Direction.REVOKE, tuple);
        }
    };

    public EStructuralFeatureBinaryInputNode(IncQueryEngine engine, ReteContainer reteContainer, EStructuralFeature feature) throws IncQueryBaseException {
        super(reteContainer);
        this.engine = engine;
        this.boundary = this.reteEngine.getBoundary();
        this.feature = feature;
        this.setTag(feature.getName());
        this.baseIndex.addFeatureListener(Collections.singleton(feature), this.listener);
        this.reteEngine.addDisconnectable((Disconnectable)this);
    }

    public void pullInto(Collection<Tuple> collector) {
        collector.addAll(this.tuples());
    }

    public void disconnect() {
        this.baseIndex.removeFeatureListener(Collections.singleton(this.feature), this.listener);
    }

    protected Tuple makeTuple(EObject source, Object target) {
        return new FlatTuple(this.boundary.wrapElement((Object)source), this.boundary.wrapElement(target));
    }

    protected Tuple makeTupleSingle(Object element) {
        return new FlatTuple(this.boundary.wrapElement(element));
    }

    protected void propagate(Direction direction, Tuple tuple) {
        this.propagateUpdate(direction, tuple);
        if (this.identityIndexer != null) {
            this.identityIndexer.propagate(direction, tuple);
        }
        if (this.nullIndexer != null) {
            this.nullIndexer.propagate(direction, tuple);
        }
    }

    protected Collection<Tuple> tuples() {
        HashSet<Tuple> result = new HashSet<Tuple>();
        return result;
    }

    public ProjectionIndexer constructIndex(TupleMask mask) {
        if (nullMask.equals((Object)mask)) {
            return this.getNullIndexer();
        }
        if (identityMask.equals((Object)mask)) {
            return this.getIdentityIndexer();
        }
        if (sourceKnown.equals((Object)mask)) {
            return this.getSourceIndexer();
        }
        if (targetKnown.equals((Object)mask)) {
            return this.getTargetIndexer();
        }
        return super.constructIndex(mask);
    }

    public NullIndexer getNullIndexer() {
        if (this.nullIndexer == null) {
            this.nullIndexer = new NullIndexer(this.reteContainer, 2, (Supplier)this, (Node)this){

                protected Collection<Tuple> getTuples() {
                    return EStructuralFeatureBinaryInputNode.this.tuples();
                }

                protected boolean isEmpty() {
                    return false;
                }

                protected boolean isSingleElement() {
                    return false;
                }
            };
        }
        return this.nullIndexer;
    }

    public IdentityIndexer getIdentityIndexer() {
        if (this.identityIndexer == null) {
            this.identityIndexer = new IdentityIndexer(this.reteContainer, 2, (Supplier)this, (Node)this){

                protected Collection<Tuple> getTuples() {
                    return EStructuralFeatureBinaryInputNode.this.tuples();
                }

                protected boolean contains(Tuple signature) {
                    return signature.getSize() == 2 && EStructuralFeatureBinaryInputNode.this.baseIndex.findByFeatureValue(signature.get(1), EStructuralFeatureBinaryInputNode.this.feature).contains(signature.get(0));
                }
            };
        }
        return this.identityIndexer;
    }

    public ProjectionIndexer getSourceIndexer() {
        if (this.sourceIndexer == null) {
            this.sourceIndexer = new SpecializedProjectionIndexer(this.reteContainer, sourceKnown, (Supplier)this, (Node)this){

                public Iterator<Tuple> iterator() {
                    return EStructuralFeatureBinaryInputNode.this.tuples().iterator();
                }

                public Collection<Tuple> get(Tuple signature) {
                    Object object;
                    if (signature.getSize() == 1 && (object = signature.get(0)) instanceof EObject) {
                        try {
                            EObject source = (EObject)object;
                            if (EStructuralFeatureBinaryInputNode.this.feature.isMany()) {
                                Collection values = (Collection)source.eGet(EStructuralFeatureBinaryInputNode.this.feature);
                                if (!values.isEmpty()) {
                                    HashSet<Tuple> result = new HashSet<Tuple>();
                                    for (Object value : values) {
                                        result.add(EStructuralFeatureBinaryInputNode.this.makeTuple(source, value));
                                    }
                                }
                            } else {
                                Object value = source.eGet(EStructuralFeatureBinaryInputNode.this.feature);
                                if (value != null) {
                                    return Collections.singleton(EStructuralFeatureBinaryInputNode.this.makeTuple(source, value));
                                }
                            }
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    return null;
                }

                public Collection<Tuple> getSignatures() {
                    Set holders = EStructuralFeatureBinaryInputNode.this.baseIndex.getHoldersOfFeature(EStructuralFeatureBinaryInputNode.this.feature);
                    if (holders == null || holders.size() == 0) {
                        return null;
                    }
                    HashSet<Tuple> result = new HashSet<Tuple>();
                    for (EObject holder : holders) {
                        result.add(EStructuralFeatureBinaryInputNode.this.makeTupleSingle(holder));
                    }
                    return result;
                }
            };
        }
        return this.sourceIndexer;
    }

    public ProjectionIndexer getTargetIndexer() {
        if (this.targetIndexer == null) {
            this.targetIndexer = new SpecializedProjectionIndexer(this.reteContainer, targetKnown, (Supplier)this, (Node)this){

                public Iterator<Tuple> iterator() {
                    return EStructuralFeatureBinaryInputNode.this.tuples().iterator();
                }

                public Collection<Tuple> get(Tuple signature) {
                    if (signature.getSize() == 1) {
                        Object value = signature.get(0);
                        Set holders = EStructuralFeatureBinaryInputNode.this.baseIndex.findByFeatureValue(value, EStructuralFeatureBinaryInputNode.this.feature);
                        if (holders == null || holders.size() == 0) {
                            return null;
                        }
                        HashSet<Tuple> result = new HashSet<Tuple>();
                        for (EObject source : holders) {
                            result.add(EStructuralFeatureBinaryInputNode.this.makeTuple(source, value));
                        }
                        return result;
                    }
                    return null;
                }

                public Collection<Tuple> getSignatures() {
                    return null;
                }
            };
        }
        return this.targetIndexer;
    }
}

