/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.patternregistry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.impl.BoolValueImpl;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.incquery.runtime.patternregistry.PatternTypeEnum;
import org.eclipse.incquery.runtime.patternregistry.internal.PatternInfo;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class GeneratedPatternSource {
    public static List<IPatternInfo> initializeRegisteredPatterns() {
        IExtensionPoint extensionPoint;
        ArrayList<IPatternInfo> resultList = new ArrayList<IPatternInfo>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry != null && (extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.incquery.runtime.queryspecification")) != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPatternInfo patternInfo;
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (configurationElement.getName().equals("matcher") && (patternInfo = GeneratedPatternSource.intializeFromConfigurationElement(configurationElement)) != null) {
                        resultList.add(patternInfo);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return resultList;
    }

    private static IPatternInfo intializeFromConfigurationElement(IConfigurationElement configurationElement) {
        String idAttributeInExtension = null;
        try {
            idAttributeInExtension = configurationElement.getAttribute("id");
            IQuerySpecificationProvider querySpecificationProvider = (IQuerySpecificationProvider)configurationElement.createExecutableExtension("querySpecificationProvider");
            IQuerySpecification querySpecification = querySpecificationProvider.get();
            String patternFullyQualifiedName = querySpecification.getPatternFullyQualifiedName();
            if (idAttributeInExtension.equals(patternFullyQualifiedName)) {
                Pattern pattern = querySpecification.getPattern();
                if (GeneratedPatternSource.hasQueryExplorerAnnotation(pattern)) {
                    PatternInfo patternInfo = new PatternInfo(PatternTypeEnum.GENERATED, pattern, null, querySpecification);
                    return patternInfo;
                }
            } else {
                IncQueryLoggingUtil.getDefaultLogger().warn((Object)("[Pattern Registry] Id attribute value " + idAttributeInExtension + " does not equal pattern FQN of query specification " + patternFullyQualifiedName + " in plugin.xml of " + configurationElement.getDeclaringExtension().getUniqueIdentifier()));
            }
        }
        catch (Exception exception) {
            if (idAttributeInExtension == null) {
                idAttributeInExtension = "undefined in plugin.xml";
            }
            IncQueryLoggingUtil.getDefaultLogger().error((Object)("[Pattern Registry] Exception during query specification registry initialization when preparing ID: " + idAttributeInExtension + "! " + exception.getMessage()), (Throwable)exception);
        }
        return null;
    }

    private static boolean hasQueryExplorerAnnotation(Pattern pattern) {
        Annotation annotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)pattern, (String)"QueryExplorer");
        if (annotation != null) {
            for (AnnotationParameter annotationParameter : annotation.getParameters()) {
                if (!annotationParameter.getName().equalsIgnoreCase("display")) continue;
                return ((BoolValueImpl)annotationParameter.getValue()).isValue();
            }
            return true;
        }
        return false;
    }
}

