/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner.cost;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public final class EvaluablePConstraint
implements Predicate<PConstraint> {
    private final SubPlan plan;
    private boolean allowInverseNavigation;

    public EvaluablePConstraint(SubPlan plan, boolean allowInverseNavigation) {
        this.plan = plan;
        this.allowInverseNavigation = allowInverseNavigation;
    }

    public boolean apply(PConstraint input) {
        if (input instanceof Inequality) {
            return Sets.difference((Set)input.getAffectedVariables(), (Set)this.plan.getAllDeducedVariables()).isEmpty();
        }
        if (input instanceof ExpressionEvaluation) {
            PVariable output = ((ExpressionEvaluation)input).getOutputVariable();
            ImmutableSet outputs = output == null ? ImmutableSet.of() : ImmutableSet.of((Object)output);
            Sets.SetView inputVariables = Sets.difference((Set)input.getAffectedVariables(), (Set)outputs);
            return Sets.difference((Set)inputVariables, (Set)this.plan.getAllDeducedVariables()).isEmpty();
        }
        if (input instanceof ExportedParameter) {
            return this.plan.getAllDeducedVariables().contains(((ExportedParameter)input).getParameterVariable());
        }
        if (input instanceof TypeConstraint && !this.allowInverseNavigation && ((IInputKey)((TypeConstraint)input).getSupplierKey()).getArity() == 2) {
            Tuple variables = ((TypeConstraint)input).getVariablesTuple();
            if (!this.plan.getAllDeducedVariables().contains(variables.get(0))) {
                return false;
            }
        }
        return true;
    }
}

