/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendOperation;

public class IterateOverContainers
extends ExtendOperation<EObject> {
    private int sourcePosition;
    private boolean transitive;

    public IterateOverContainers(int position, int sourcePosition, boolean transitive) {
        super(position);
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Preconditions.checkState((boolean)(frame.get(this.sourcePosition) instanceof EObject), (Object)"Only children of EObject elements are supported.");
        EObject source = (EObject)frame.get(this.sourcePosition);
        this.it = this.transitive ? new ParentIterator(source) : Iterators.singletonIterator((Object)source.eContainer());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IterateOverContainers(");
        builder.append(this.position + ", " + this.sourcePosition + ", " + this.transitive);
        builder.append(")");
        return builder.toString();
    }

    private static final class ParentIterator
    implements Iterator<EObject> {
        private EObject current;

        public ParentIterator(EObject source) {
            this.current = source;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EObject next() {
            EObject newObject = this.current.eContainer();
            if (newObject == null) {
                throw new NoSuchElementException(String.format("No more parents available for EObject %s", this.current));
            }
            this.current = newObject;
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current.eContainer() != null;
        }
    }
}

