/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;

public class ContainmentCheck
extends CheckOperation {
    Integer childPosition;
    Integer containerPosition;
    private boolean transitive;

    public ContainmentCheck(int childPosition, int containerPosition, boolean transitive) {
        this.childPosition = childPosition;
        this.containerPosition = containerPosition;
        this.transitive = transitive;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        try {
            EObject child = (EObject)frame.getValue(this.childPosition);
            EObject container = (EObject)frame.getValue(this.containerPosition);
            if (this.transitive) {
                return EcoreUtil.isAncestor((EObject)container, (EObject)child);
            }
            return child.eContainer().equals(container);
        }
        catch (ClassCastException e) {
            throw new LocalSearchException("Invalid type of variable", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ContainmentCheck(");
        builder.append(this.childPosition + ", " + this.containerPosition + ", " + this.transitive);
        builder.append(")");
        return builder.toString();
    }
}

