/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.MatchingTable;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlanExecutor;

public class LocalSearchMatcher {
    private ImmutableList<SearchPlanExecutor> plan;
    private int frameSize;
    private int keySize;

    protected LocalSearchMatcher() {
    }

    public LocalSearchMatcher(SearchPlanExecutor plan, int keySize, int framesize) {
        this.keySize = keySize;
        this.plan = ImmutableList.of((Object)plan);
        this.frameSize = framesize;
    }

    protected void setPlan(SearchPlanExecutor plan) {
        this.plan = ImmutableList.of((Object)plan);
    }

    protected void setPlan(SearchPlanExecutor[] plan) {
        this.plan = ImmutableList.copyOf((Object[])plan);
    }

    protected void setFramesize(int frameSize) {
        this.frameSize = frameSize;
    }

    protected void setKeysize(int keySize) {
        this.keySize = keySize;
    }

    public MatchingFrame editableMatchingFrame() {
        return new MatchingFrame(null, this.keySize, this.frameSize);
    }

    public boolean hasMatch() throws LocalSearchException {
        return this.hasMatch(this.editableMatchingFrame());
    }

    public boolean hasMatch(MatchingFrame initialFrame) throws LocalSearchException {
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        return it.hasNext();
    }

    public int countMatches() throws LocalSearchException {
        return this.countMatches(this.editableMatchingFrame());
    }

    public int countMatches(MatchingFrame initialFrame) throws LocalSearchException {
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        return Iterators.size((Iterator)((Object)it));
    }

    public MatchingFrame getOneArbitraryMatch() throws LocalSearchException {
        return this.getOneArbitraryMatch(this.editableMatchingFrame());
    }

    public MatchingFrame getOneArbitraryMatch(MatchingFrame initialFrame) throws LocalSearchException {
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Collection<MatchingFrame> getAllMatches() throws LocalSearchException {
        return this.getAllMatches(this.editableMatchingFrame());
    }

    public Collection<MatchingFrame> getAllMatches(MatchingFrame initialFrame) throws LocalSearchException {
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        MatchingTable results = new MatchingTable();
        while (it.hasNext()) {
            MatchingFrame frame = it.next();
            results.put(frame.getKey(), frame);
        }
        return ImmutableList.copyOf(results.iterator());
    }

    private static class PlanExecutionIterator
    extends UnmodifiableIterator<MatchingFrame> {
        private UnmodifiableIterator<SearchPlanExecutor> iterator;
        private SearchPlanExecutor currentPlan;
        private MatchingFrame frame;

        public PlanExecutionIterator(ImmutableList<SearchPlanExecutor> plan, MatchingFrame initialFrame) {
            this.frame = initialFrame.clone();
            Preconditions.checkArgument((plan.size() > 0 ? 1 : 0) != 0);
            this.iterator = plan.iterator();
            this.getNextPlan();
        }

        private void getNextPlan() {
            this.currentPlan = (SearchPlanExecutor)this.iterator.next();
            this.currentPlan.resetPlan();
        }

        public boolean hasNext() {
            try {
                boolean foundMatch = this.currentPlan.execute(this.frame);
                while (!foundMatch && this.iterator.hasNext()) {
                    this.getNextPlan();
                    foundMatch = this.currentPlan.execute(this.frame);
                }
                return foundMatch;
            }
            catch (LocalSearchException e) {
                throw new RuntimeException(e);
            }
        }

        public MatchingFrame next() {
            return this.frame.clone();
        }
    }
}

