/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific;

import java.util.Collection;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryMultiPatternMatchEventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQuerySinglePatternMatchEventFilter;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public final class Rules {
    public static <Match extends IPatternMatch> RuleSpecification<Match> newMatcherRuleSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, ActivationLifeCycle lifecycle, Set<Job<Match>> jobs) {
        return new RuleSpecification(IncQueryEventRealm.createSourceSpecification(querySpecification), lifecycle, jobs);
    }

    public static <Match extends IPatternMatch> RuleSpecification<Match> newMatcherRuleSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, Set<Job<Match>> jobs) {
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT, jobs);
    }

    public static <Match extends IPatternMatch> RuleSpecification<Match> newMatcherRuleSpecification(IncQueryMatcher<Match> matcher, ActivationLifeCycle lifecycle, Set<Job<Match>> jobs) {
        FavouredMatcherSourceSpecification<Match> sourceSpecification = new FavouredMatcherSourceSpecification<Match>(matcher);
        return new RuleSpecification<Match>(sourceSpecification, lifecycle, jobs);
    }

    public static <Match extends IPatternMatch> EventFilter<Match> newSingleMatchFilter(Match filterMatch) {
        return IncQuerySinglePatternMatchEventFilter.createFilter(filterMatch);
    }

    public static <Match extends IPatternMatch> EventFilter<Match> newMultiMatchFilter(Collection<Match> filterMatches, IncQueryFilterSemantics semantics) {
        return IncQueryMultiPatternMatchEventFilter.createFilter(filterMatches, semantics);
    }

    private static final class FavouredMatcherSourceSpecification<Match extends IPatternMatch>
    extends IncQueryEventSourceSpecification<Match> {
        private final IncQueryMatcher<Match> matcher;

        public FavouredMatcherSourceSpecification(IncQueryMatcher<Match> matcher) {
            super(matcher.getSpecification());
            this.matcher = matcher;
        }

        @Override
        protected IncQueryMatcher<Match> getMatcher(IncQueryEngine engine) throws IncQueryException {
            if (this.matcher.getEngine().equals(engine)) {
                return this.matcher;
            }
            return super.getMatcher(engine);
        }
    }
}

