/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.itc.alg.counting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.alg.counting.CountingTcRelation;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.CollectionHelper;
import org.eclipse.incquery.runtime.base.itc.alg.misc.GraphHelper;
import org.eclipse.incquery.runtime.base.itc.alg.misc.ITcRelation;
import org.eclipse.incquery.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.ITcObserver;

public class CountingAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    private static final long serialVersionUID = -2383210800242398869L;
    private CountingTcRelation<V> tc = null;
    private CountingTcRelation<V> dtc = null;
    private IBiDirectionalGraphDataSource<V> gds = null;
    private ArrayList<ITcObserver<V>> observers;

    public CountingAlg(IGraphDataSource<V> gds) {
        this.gds = gds instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)gds : new IBiDirectionalWrapper<V>(gds);
        this.observers = new ArrayList();
        this.tc = new CountingTcRelation(true);
        this.dtc = new CountingTcRelation(false);
        this.initTc();
        gds.attachObserver(this);
    }

    private void initTc() {
        this.setTcRelation(CountingTcRelation.createFrom(this.gds));
    }

    @Override
    public void edgeInserted(V source, V target) {
        if (!source.equals(target)) {
            this.deriveTc(source, target, 1);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        if (!source.equals(target)) {
            this.deriveTc(source, target, -1);
        }
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V n) {
        this.tc.deleteTupleEnd(n);
    }

    private void deriveTc(V source, V target, int dCount) {
        this.dtc.clear();
        Set<V> tupEnds = null;
        if (this.tc.addTuple(source, target, dCount)) {
            this.dtc.addTuple(source, target, dCount);
            this.notifyTcObservers(source, target, dCount);
        }
        if ((tupEnds = this.tc.getTupleEnds(target)) != null) {
            for (V tupEnd : tupEnds) {
                if (tupEnd.equals(source) || !this.tc.addTuple(source, tupEnd, dCount)) continue;
                this.dtc.addTuple(source, tupEnd, dCount);
                this.notifyTcObservers(source, tupEnd, dCount);
            }
        }
        CountingTcRelation<V> newTuples = new CountingTcRelation<V>(false);
        CountingTcRelation<V> tmp = null;
        List<V> nodes = null;
        newTuples.union(this.dtc);
        while (!newTuples.isEmpty()) {
            tmp = this.dtc;
            this.dtc = newTuples;
            newTuples = tmp;
            newTuples.clear();
            for (V tS : this.dtc.getTupleStarts()) {
                nodes = this.gds.getSourceNodes(tS);
                if (nodes == null) continue;
                for (V nS : nodes) {
                    tupEnds = this.dtc.getTupleEnds(tS);
                    if (tupEnds == null) continue;
                    for (V tT : tupEnds) {
                        if (nS.equals(tT) || !this.tc.addTuple(nS, tT, dCount)) continue;
                        newTuples.addTuple(nS, tT, dCount);
                        this.notifyTcObservers(nS, tT, dCount);
                    }
                }
            }
        }
    }

    public ITcRelation<V> getTcRelation() {
        return this.tc;
    }

    public void setTcRelation(CountingTcRelation<V> tc) {
        this.tc = tc;
    }

    @Override
    public boolean isReachable(V source, V target) {
        return this.tc.containsTuple(source, target);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        HashSet<V> targets = new HashSet<V>();
        if (this.tc.getTupleEnds(source) != null) {
            targets.addAll(this.tc.getTupleEnds(source));
        }
        return targets;
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        HashSet<V> sources = new HashSet<V>();
        if (this.tc.getTupleStarts(target) != null) {
            sources.addAll(this.tc.getTupleStarts(target));
        }
        return sources;
    }

    @Override
    public List<V> getReachabilityPath(V source, V target) {
        if (!this.isReachable(source, target)) {
            return null;
        }
        Set<V> nodesInSubGraph = CollectionHelper.intersection(this.getAllReachableSources(target), this.getAllReachableTargets(source));
        nodesInSubGraph.add(source);
        nodesInSubGraph.add(target);
        return GraphHelper.constructPath(source, target, nodesInSubGraph, this.gds);
    }

    private void notifyTcObservers(V source, V target, int dir) {
        for (ITcObserver<V> o : this.observers) {
            if (dir == 1) {
                o.tupleInserted(source, target);
            }
            if (dir != -1) continue;
            o.tupleDeleted(source, target);
        }
    }

    @Override
    public void dispose() {
        this.tc.clear();
        this.dtc.clear();
        this.gds.detachObserver(this);
    }
}

