/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapterUtil;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchCollectionBuilder;
import org.eclipse.incquery.databinding.runtime.observables.ObservableLabelFeature;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;

public final class IncQueryObservables {
    private IncQueryObservables() {
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableList observeMatchesAsList(Matcher matcher) {
        return ObservablePatternMatchCollectionBuilder.create(matcher).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableList observeMatchesAsList(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableList observeMatchesAsList(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Match filter) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setFilter(filter).setEngine(engine).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableSet observeMatchesAsSet(Matcher matcher) {
        return ObservablePatternMatchCollectionBuilder.create(matcher).buildSet();
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableSet observeMatchesAsSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine).buildSet();
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> IObservableSet observeMatchesAsSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Match filter) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setFilter(filter).setEngine(engine).buildSet();
    }

    public static List<IObservableValue> observeFeatures(IPatternMatch match, IValueChangeListener changeListener, String message) {
        if (message == null) {
            return Lists.newArrayList();
        }
        ArrayList<IObservableValue> affectedValues = new ArrayList<IObservableValue>();
        String[] tokens = message.split("\\$");
        int i = 1;
        while (i < tokens.length) {
            IObservableValue value = IncQueryObservables.getObservableValue(match, tokens[i]);
            if (value != null) {
                value.addValueChangeListener(changeListener);
                affectedValues.add(value);
            }
            i += 2;
        }
        return affectedValues;
    }

    public static List<IObservableValue> observeAllAttributes(IValueChangeListener changeListener, Object object) {
        ArrayList<IObservableValue> affectedValues = new ArrayList<IObservableValue>();
        if (object instanceof EObject) {
            for (EStructuralFeature feature : ((EObject)object).eClass().getEAllStructuralFeatures()) {
                IObservableValue val = EMFProperties.value((EStructuralFeature)feature).observe(object);
                affectedValues.add(val);
                val.addValueChangeListener(changeListener);
            }
        }
        return affectedValues;
    }

    public static IObservableValue getObservableValue(IPatternMatch match, String expression) {
        IObservableValue val = null;
        String[] objectTokens = expression.split("\\.");
        if (objectTokens.length > 0) {
            Object o = null;
            EStructuralFeature feature = null;
            if (objectTokens.length == 2) {
                o = match.get(objectTokens[0]);
                feature = DatabindingAdapterUtil.getFeature(o, objectTokens[1]);
            }
            if (objectTokens.length == 1) {
                o = match.get(objectTokens[0]);
                feature = DatabindingAdapterUtil.getFeature(o, "name");
            }
            val = o != null && feature != null ? EMFProperties.value(feature).observe(o) : (o != null && feature == null ? Observables.constantObservableValue((Object)o.toString()) : Observables.constantObservableValue((Object)expression));
        }
        return val;
    }

    public static IObservableValue getObservableLabelFeature(IPatternMatch match, String expression) {
        return IncQueryObservables.getObservableLabelFeature(match, expression, null);
    }

    public static IObservableValue getObservableLabelFeature(IPatternMatch match, String expression, Object container) {
        ObservableLabelFeature value = new ObservableLabelFeature(match, expression, container);
        return value;
    }
}

