/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewmodel.core;

import java.util.Collection;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewmodel.core.ViewModelRule;
import org.eclipse.incquery.viewmodel.traceability.Traceability;
import org.eclipse.incquery.viewmodel.traceability.TraceabilityFactory;

public class ViewModelManager {
    private static final String TRACEBILITY_RESOURCE = "org.eclipse.incquery.viewmodel.traceability.TraceabilityResource";
    private IncQueryEngine engine;
    private ExecutionSchema executionSchema;
    private Collection<ViewModelRule> rules;
    private Traceability traceability = TraceabilityFactory.eINSTANCE.createTraceability();
    private String traceabilityId = UUID.randomUUID().toString();

    public void initialize() throws IncQueryException, QueryInitializationException {
        this.prepareBaseNotifier();
        this.traceability.setId(this.traceabilityId);
        this.executionSchema = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)this.engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)this.engine));
        for (ViewModelRule rule : this.rules) {
            rule.initialize(this.traceabilityId);
            rule.getTracedSpecification().getMatcher(this.engine);
            rule.getReferencedSpecification().getMatcher(this.engine);
            rule.getBaseSpecification().getMatcher(this.engine);
            rule.createRuleSpecification(this.executionSchema);
        }
        Logger.getLogger(this.getClass()).info((Object)"View model manager initialized");
        this.executionSchema.startUnscheduledExecution();
        Logger.getLogger(this.getClass()).info((Object)"Unscheduled execution started");
    }

    private void prepareBaseNotifier() {
        ResourceSet resourceSet = this.getResourceSet();
        Resource resource = null;
        for (Resource r : resourceSet.getResources()) {
            if (!r.getURI().toString().equals(this.getTraceabilityResourceId())) continue;
            resource = r;
            break;
        }
        if (resource == null) {
            resource = resourceSet.createResource(URI.createURI((String)this.getTraceabilityResourceId()));
        }
        resource.getContents().add((Object)this.traceability);
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public void setEngine(IncQueryEngine engine) {
        if (!(engine.getScope() instanceof EMFScope)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for IncQueryEngine");
            return;
        }
        if (!(((EMFScope)engine.getScope()).getScopeRoot() instanceof ResourceSet)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only ResourceSet is supported currently for EMFScope");
            return;
        }
        this.engine = engine;
    }

    private ResourceSet getResourceSet() {
        return (ResourceSet)((EMFScope)this.engine.getScope()).getScopeRoot();
    }

    public void setRules(Collection<ViewModelRule> rules) {
        this.rules = rules;
    }

    public Traceability getTraceability() {
        return this.traceability;
    }

    public void dispose() {
        EcoreUtil.delete((EObject)this.traceability);
        this.executionSchema.dispose();
    }

    private String getTraceabilityResourceId() {
        return TRACEBILITY_RESOURCE;
    }
}

