package org.eclipse.incquery.viewers.runtime.model.patterns;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2itemQuerySpecification;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.viewers.runtime.model.patterns.param2item pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link Param2itemMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * {@literal @}QueryExplorer(checked = false)
 * pattern param2item(param, trace : Trace, item : Item) {
 * 	Trace.params(trace, param);
 * 	Trace.targets(trace, item);
 * } or {
 * 	Trace.objects(trace, param);
 * 	Trace.targets(trace, item);
 * }
 * </pre></code>
 * 
 * @see Param2itemMatch
 * @see Param2itemProcessor
 * @see Param2itemQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class Param2itemMatcher extends BaseMatcher<Param2itemMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static Param2itemMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    Param2itemMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new Param2itemMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_PARAM = 0;
  
  private final static int POSITION_TRACE = 1;
  
  private final static int POSITION_ITEM = 2;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(Param2itemMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public Param2itemMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public Param2itemMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return matches represented as a Param2itemMatch object.
   * 
   */
  public Collection<Param2itemMatch> getAllMatches(final Object pParam, final Trace pTrace, final Item pItem) {
    return rawGetAllMatches(new Object[]{pParam, pTrace, pItem});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return a match represented as a Param2itemMatch object, or null if no match is found.
   * 
   */
  public Param2itemMatch getOneArbitraryMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    return rawGetOneArbitraryMatch(new Object[]{pParam, pTrace, pItem});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    return rawHasMatch(new Object[]{pParam, pTrace, pItem});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Object pParam, final Trace pTrace, final Item pItem) {
    return rawCountMatches(new Object[]{pParam, pTrace, pItem});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Object pParam, final Trace pTrace, final Item pItem, final IMatchProcessor<? super Param2itemMatch> processor) {
    rawForEachMatch(new Object[]{pParam, pTrace, pItem}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Object pParam, final Trace pTrace, final Item pItem, final IMatchProcessor<? super Param2itemMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pParam, pTrace, pItem}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public Param2itemMatch newMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    return Param2itemMatch.newMatch(pParam, pTrace, pItem);
  }
  
  /**
   * Retrieve the set of values that occur in matches for param.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Object> rawAccumulateAllValuesOfparam(final Object[] parameters) {
    Set<Object> results = new HashSet<Object>();
    rawAccumulateAllValues(POSITION_PARAM, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for param.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfparam() {
    return rawAccumulateAllValuesOfparam(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for param.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfparam(final Param2itemMatch partialMatch) {
    return rawAccumulateAllValuesOfparam(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for param.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Object> getAllValuesOfparam(final Trace pTrace, final Item pItem) {
    return rawAccumulateAllValuesOfparam(new Object[]{
    null, 
    pTrace, 
    pItem
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Trace> rawAccumulateAllValuesOftrace(final Object[] parameters) {
    Set<Trace> results = new HashSet<Trace>();
    rawAccumulateAllValues(POSITION_TRACE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace() {
    return rawAccumulateAllValuesOftrace(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace(final Param2itemMatch partialMatch) {
    return rawAccumulateAllValuesOftrace(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for trace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Trace> getAllValuesOftrace(final Object pParam, final Item pItem) {
    return rawAccumulateAllValuesOftrace(new Object[]{
    pParam, 
    null, 
    pItem
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for item.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Item> rawAccumulateAllValuesOfitem(final Object[] parameters) {
    Set<Item> results = new HashSet<Item>();
    rawAccumulateAllValues(POSITION_ITEM, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for item.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Item> getAllValuesOfitem() {
    return rawAccumulateAllValuesOfitem(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for item.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Item> getAllValuesOfitem(final Param2itemMatch partialMatch) {
    return rawAccumulateAllValuesOfitem(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for item.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Item> getAllValuesOfitem(final Object pParam, final Trace pTrace) {
    return rawAccumulateAllValuesOfitem(new Object[]{
    pParam, 
    pTrace, 
    null
    });
  }
  
  @Override
  protected Param2itemMatch tupleToMatch(final Tuple t) {
    try {
    	return Param2itemMatch.newMatch((java.lang.Object) t.get(POSITION_PARAM), (org.eclipse.incquery.viewmodel.traceability.Trace) t.get(POSITION_TRACE), (org.eclipse.incquery.viewers.runtime.model.Item) t.get(POSITION_ITEM));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected Param2itemMatch arrayToMatch(final Object[] match) {
    try {
    	return Param2itemMatch.newMatch((java.lang.Object) match[POSITION_PARAM], (org.eclipse.incquery.viewmodel.traceability.Trace) match[POSITION_TRACE], (org.eclipse.incquery.viewers.runtime.model.Item) match[POSITION_ITEM]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected Param2itemMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return Param2itemMatch.newMutableMatch((java.lang.Object) match[POSITION_PARAM], (org.eclipse.incquery.viewmodel.traceability.Trace) match[POSITION_TRACE], (org.eclipse.incquery.viewers.runtime.model.Item) match[POSITION_ITEM]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<Param2itemMatcher> querySpecification() throws IncQueryException {
    return Param2itemQuerySpecification.instance();
  }
}
