package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.MessageMessageKindMatch;
import org.eclipse.incquery.uml.derivedfeatures.MessageMessageKindMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.MessageReceiveEventQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.MessageSendEventQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate MessageMessageKindMatcher in a type-safe way.
 * 
 * @see MessageMessageKindMatcher
 * @see MessageMessageKindMatch
 * 
 */
@SuppressWarnings("all")
public final class MessageMessageKindQuerySpecification extends BaseGeneratedEMFQuerySpecification<MessageMessageKindMatcher> {
  private MessageMessageKindQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static MessageMessageKindQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected MessageMessageKindMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return MessageMessageKindMatcher.on(engine);
  }
  
  @Override
  public MessageMessageKindMatch newEmptyMatch() {
    return MessageMessageKindMatch.newEmptyMatch();
  }
  
  @Override
  public MessageMessageKindMatch newMatch(final Object... parameters) {
    return MessageMessageKindMatch.newMatch((org.eclipse.uml2.uml.Message) parameters[0], (org.eclipse.uml2.uml.MessageKind) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link MessageMessageKindQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link MessageMessageKindQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static MessageMessageKindQuerySpecification INSTANCE = new MessageMessageKindQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static MessageMessageKindQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.messageMessageKind";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","messageKind");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Message"),new PParameter("messageKind", "org.eclipse.uml2.uml.MessageKind"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_messageKind = body.getOrCreateVariableByName("messageKind");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		PVariable var___1_ = body.getOrCreateVariableByName("_<1>");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message")));
      		new TypeConstraint(body, new FlatTuple(var_messageKind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "MessageKind")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_messageKind, "messageKind")
      		));
      		//     neg find messageSendEvent(self, _)
      		new NegativePatternCall(body, new FlatTuple(var_self, var___0_), MessageSendEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     neg find messageReceiveEvent(self, _)
      		new NegativePatternCall(body, new FlatTuple(var_self, var___1_), MessageReceiveEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     messageKind == MessageKind::unknown
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.MessageKind.get("unknown"));
      		new Equality(body, var_messageKind, var__virtual_0_);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_messageKind = body.getOrCreateVariableByName("messageKind");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		PVariable var___1_ = body.getOrCreateVariableByName("_<1>");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message")));
      		new TypeConstraint(body, new FlatTuple(var_messageKind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "MessageKind")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_messageKind, "messageKind")
      		));
      		//     neg find messageSendEvent(self, _)
      		new NegativePatternCall(body, new FlatTuple(var_self, var___0_), MessageSendEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     find messageReceiveEvent(self, _)
      		new PositivePatternCall(body, new FlatTuple(var_self, var___1_), MessageReceiveEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     messageKind == MessageKind::found
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.MessageKind.get("found"));
      		new Equality(body, var_messageKind, var__virtual_0_);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_messageKind = body.getOrCreateVariableByName("messageKind");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		PVariable var___1_ = body.getOrCreateVariableByName("_<1>");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message")));
      		new TypeConstraint(body, new FlatTuple(var_messageKind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "MessageKind")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_messageKind, "messageKind")
      		));
      		//     find messageSendEvent(self, _)
      		new PositivePatternCall(body, new FlatTuple(var_self, var___0_), MessageSendEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     neg find messageReceiveEvent(self, _)
      		new NegativePatternCall(body, new FlatTuple(var_self, var___1_), MessageReceiveEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     messageKind == MessageKind::lost
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.MessageKind.get("lost"));
      		new Equality(body, var_messageKind, var__virtual_0_);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_messageKind = body.getOrCreateVariableByName("messageKind");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		PVariable var___1_ = body.getOrCreateVariableByName("_<1>");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message")));
      		new TypeConstraint(body, new FlatTuple(var_messageKind), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "MessageKind")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_messageKind, "messageKind")
      		));
      		//     find messageSendEvent(self, _)
      		new PositivePatternCall(body, new FlatTuple(var_self, var___0_), MessageSendEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     find messageReceiveEvent(self, _)
      		new PositivePatternCall(body, new FlatTuple(var_self, var___1_), MessageReceiveEventQuerySpecification.instance().getInternalQueryRepresentation());
      		//     messageKind == MessageKind::complete
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new ConstantValue(body, var__virtual_0_, org.eclipse.uml2.uml.MessageKind.get("complete"));
      		new Equality(body, var_messageKind, var__virtual_0_);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "messageKind");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
