package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ActivityNodeActivityMatch;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.activityNodeActivity pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ActivityNodeActivityProcessor implements IMatchProcessor<ActivityNodeActivityMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final ActivityNode pSource, final Activity pTarget);
  
  @Override
  public void process(final ActivityNodeActivityMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
