/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.health.HealthMessages;
import io.smallrye.health.Response;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

class ResponseBuilder
extends HealthCheckResponseBuilder {
    private String name;
    private HealthCheckResponse.Status status = HealthCheckResponse.Status.DOWN;
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();

    ResponseBuilder() {
    }

    @Override
    public HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, long value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public HealthCheckResponseBuilder withData(String key, boolean value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public HealthCheckResponseBuilder up() {
        this.status = HealthCheckResponse.Status.UP;
        return this;
    }

    @Override
    public HealthCheckResponseBuilder down() {
        this.status = HealthCheckResponse.Status.DOWN;
        return this;
    }

    @Override
    public HealthCheckResponseBuilder status(boolean up) {
        if (up) {
            return this.up();
        }
        return this.down();
    }

    @Override
    public HealthCheckResponse build() {
        if (null == this.name || this.name.trim().length() == 0) {
            throw HealthMessages.msg.invalidHealthCheckName();
        }
        return new Response(this.name, this.status, this.data.isEmpty() ? null : this.data);
    }
}

