/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.compiler.parser.ASTAdditiveExpression;
import org.eclipse.golo.compiler.parser.ASTAndExpression;
import org.eclipse.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTArgument;
import org.eclipse.golo.compiler.parser.ASTAssignment;
import org.eclipse.golo.compiler.parser.ASTAugmentDeclaration;
import org.eclipse.golo.compiler.parser.ASTBlock;
import org.eclipse.golo.compiler.parser.ASTBreak;
import org.eclipse.golo.compiler.parser.ASTCase;
import org.eclipse.golo.compiler.parser.ASTCollectionLiteral;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.ASTConditionalBranching;
import org.eclipse.golo.compiler.parser.ASTContinue;
import org.eclipse.golo.compiler.parser.ASTDecoratorDeclaration;
import org.eclipse.golo.compiler.parser.ASTDestructuringAssignment;
import org.eclipse.golo.compiler.parser.ASTEqualityExpression;
import org.eclipse.golo.compiler.parser.ASTExpressionStatement;
import org.eclipse.golo.compiler.parser.ASTForEachLoop;
import org.eclipse.golo.compiler.parser.ASTForLoop;
import org.eclipse.golo.compiler.parser.ASTFunction;
import org.eclipse.golo.compiler.parser.ASTFunctionDeclaration;
import org.eclipse.golo.compiler.parser.ASTFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTImportDeclaration;
import org.eclipse.golo.compiler.parser.ASTInvocationExpression;
import org.eclipse.golo.compiler.parser.ASTLetOrVar;
import org.eclipse.golo.compiler.parser.ASTLiteral;
import org.eclipse.golo.compiler.parser.ASTMatch;
import org.eclipse.golo.compiler.parser.ASTMemberDeclaration;
import org.eclipse.golo.compiler.parser.ASTMethodInvocation;
import org.eclipse.golo.compiler.parser.ASTModuleDeclaration;
import org.eclipse.golo.compiler.parser.ASTMultiplicativeExpression;
import org.eclipse.golo.compiler.parser.ASTNamedAugmentationDeclaration;
import org.eclipse.golo.compiler.parser.ASTOrExpression;
import org.eclipse.golo.compiler.parser.ASTOrIfNullExpression;
import org.eclipse.golo.compiler.parser.ASTReference;
import org.eclipse.golo.compiler.parser.ASTRelationalExpression;
import org.eclipse.golo.compiler.parser.ASTReturn;
import org.eclipse.golo.compiler.parser.ASTStructDeclaration;
import org.eclipse.golo.compiler.parser.ASTThrow;
import org.eclipse.golo.compiler.parser.ASTToplevelDeclaration;
import org.eclipse.golo.compiler.parser.ASTTryCatchFinally;
import org.eclipse.golo.compiler.parser.ASTUnaryExpression;
import org.eclipse.golo.compiler.parser.ASTUnionDeclaration;
import org.eclipse.golo.compiler.parser.ASTUnionValue;
import org.eclipse.golo.compiler.parser.ASTWhileLoop;
import org.eclipse.golo.compiler.parser.ASTerror;
import org.eclipse.golo.compiler.parser.GoloParserVisitor;
import org.eclipse.golo.compiler.parser.SimpleNode;
import org.eclipse.golo.doc.AugmentationDocumentation;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.FunctionDocumentation;
import org.eclipse.golo.doc.MemberHolder;
import org.eclipse.golo.doc.NamedAugmentationDocumentation;
import org.eclipse.golo.doc.StructDocumentation;
import org.eclipse.golo.doc.UnionDocumentation;

class ModuleDocumentation
implements DocumentationElement {
    private String moduleName;
    private int moduleDefLine;
    private String moduleDocumentation;
    private final Map<String, Integer> imports = new TreeMap<String, Integer>();
    private final Map<String, Integer> moduleStates = new TreeMap<String, Integer>();
    private final SortedSet<FunctionDocumentation> functions = new TreeSet<FunctionDocumentation>();
    private final Map<String, AugmentationDocumentation> augmentations = new TreeMap<String, AugmentationDocumentation>();
    private final SortedSet<StructDocumentation> structs = new TreeSet<StructDocumentation>();
    private final SortedSet<UnionDocumentation> unions = new TreeSet<UnionDocumentation>();
    private final Set<NamedAugmentationDocumentation> namedAugmentations = new TreeSet<NamedAugmentationDocumentation>();

    @Override
    public String type() {
        return "module";
    }

    ModuleDocumentation(ASTCompilationUnit compilationUnit) {
        new ModuleVisitor().visit(compilationUnit, null);
    }

    public String goloVersion() {
        return Metadata.VERSION;
    }

    public SortedSet<StructDocumentation> structs() {
        return this.structs;
    }

    public SortedSet<UnionDocumentation> unions() {
        return this.unions;
    }

    public SortedSet<FunctionDocumentation> functions() {
        return this.functions(false);
    }

    public SortedSet<FunctionDocumentation> functions(boolean withLocal) {
        if (withLocal) {
            return this.functions;
        }
        TreeSet<FunctionDocumentation> pubFunctions = new TreeSet<FunctionDocumentation>();
        for (FunctionDocumentation f : this.functions) {
            if (f.local()) continue;
            pubFunctions.add(f);
        }
        return pubFunctions;
    }

    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public String name() {
        return this.moduleName;
    }

    @Override
    public String fullName() {
        return this.moduleName;
    }

    @Override
    public String id() {
        return "";
    }

    @Override
    public DocumentationElement parent() {
        return this;
    }

    public int moduleDefLine() {
        return this.moduleDefLine;
    }

    @Override
    public int line() {
        return this.moduleDefLine;
    }

    public String moduleDocumentation() {
        return this.moduleDocumentation != null ? this.moduleDocumentation : "\n";
    }

    @Override
    public String documentation() {
        return this.moduleDocumentation();
    }

    public Map<String, Integer> moduleStates() {
        return this.moduleStates;
    }

    public Collection<AugmentationDocumentation> augmentations() {
        return this.augmentations.values();
    }

    public Collection<NamedAugmentationDocumentation> namedAugmentations() {
        return this.namedAugmentations;
    }

    public Map<String, Integer> imports() {
        return this.imports;
    }

    private class ModuleVisitor
    implements GoloParserVisitor {
        private Deque<Set<FunctionDocumentation>> functionContext = new LinkedList<Set<FunctionDocumentation>>();
        private FunctionDocumentation currentFunction = null;
        private UnionDocumentation currentUnion;
        private MemberHolder currentMemberHolder;
        private Deque<DocumentationElement> parents = new LinkedList<DocumentationElement>();

        private ModuleVisitor() {
        }

        @Override
        public Object visit(ASTCompilationUnit node, Object data) {
            this.functionContext.push(ModuleDocumentation.this.functions);
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTModuleDeclaration node, Object data) {
            ModuleDocumentation.this.moduleName = node.getName();
            ModuleDocumentation.this.moduleDefLine = node.getLineInSourceCode();
            ModuleDocumentation.this.moduleDocumentation = node.getDocumentation();
            this.parents.push(ModuleDocumentation.this);
            return data;
        }

        @Override
        public Object visit(ASTImportDeclaration node, Object data) {
            ModuleDocumentation.this.imports.put(node.getName(), node.getLineInSourceCode());
            return data;
        }

        @Override
        public Object visit(ASTToplevelDeclaration node, Object data) {
            node.childrenAccept(this, data);
            return data;
        }

        @Override
        public Object visit(ASTMemberDeclaration node, Object data) {
            this.currentMemberHolder.addMember(node.getName()).parent(this.parents.peek()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            return data;
        }

        @Override
        public Object visit(ASTStructDeclaration node, Object data) {
            StructDocumentation doc = new StructDocumentation().parent(this.parents.peek()).name(node.getName()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            ModuleDocumentation.this.structs.add(doc);
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            Object result = node.childrenAccept(this, data);
            this.parents.pop();
            this.currentMemberHolder = null;
            return result;
        }

        @Override
        public Object visit(ASTUnionDeclaration node, Object data) {
            this.currentUnion = new UnionDocumentation().parent(this.parents.peek()).name(node.getName()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            ModuleDocumentation.this.unions.add(this.currentUnion);
            this.parents.push(this.currentUnion);
            Object r = node.childrenAccept(this, data);
            this.parents.pop();
            return r;
        }

        @Override
        public Object visit(ASTUnionValue node, Object data) {
            UnionDocumentation.UnionValueDocumentation doc = this.currentUnion.addValue(node.getName()).parent(this.parents.peek()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            Object result = node.childrenAccept(this, data);
            this.parents.pop();
            this.currentMemberHolder = null;
            return result;
        }

        @Override
        public Object visit(ASTAugmentDeclaration node, Object data) {
            String target = node.getName();
            if (!ModuleDocumentation.this.augmentations.containsKey(target)) {
                ModuleDocumentation.this.augmentations.put(target, new AugmentationDocumentation().target(target).parent(this.parents.peek()).augmentationNames(node.getAugmentationNames()).line(node.getLineInSourceCode()));
            }
            AugmentationDocumentation ad = ((AugmentationDocumentation)ModuleDocumentation.this.augmentations.get(target)).documentation(node.getDocumentation());
            this.functionContext.push(ad);
            this.parents.push(ad);
            node.childrenAccept(this, data);
            this.functionContext.pop();
            this.parents.pop();
            return data;
        }

        @Override
        public Object visit(ASTNamedAugmentationDeclaration node, Object data) {
            NamedAugmentationDocumentation augment = new NamedAugmentationDocumentation().parent(this.parents.peek()).name(node.getName()).documentation(node.getDocumentation()).line(node.getLineInSourceCode());
            ModuleDocumentation.this.namedAugmentations.add(augment);
            this.functionContext.push(augment);
            this.parents.push(augment);
            node.childrenAccept(this, data);
            this.functionContext.pop();
            this.parents.pop();
            return data;
        }

        @Override
        public Object visit(ASTFunctionDeclaration node, Object data) {
            this.currentFunction = new FunctionDocumentation().parent(this.parents.peek()).name(node.getName()).documentation(node.getDocumentation()).augmentation(node.isAugmentation()).line(node.getLineInSourceCode()).local(node.isLocal());
            this.functionContext.peek().add(this.currentFunction);
            node.childrenAccept(this, data);
            this.currentFunction = null;
            return data;
        }

        @Override
        public Object visit(ASTFunction node, Object data) {
            if (this.currentFunction != null) {
                this.currentFunction.arguments(node.getParameters()).varargs(node.isVarargs());
            }
            return data;
        }

        @Override
        public Object visit(ASTLetOrVar node, Object data) {
            if (node.isModuleState()) {
                ModuleDocumentation.this.moduleStates.put(node.getName(), node.getLineInSourceCode());
            }
            return data;
        }

        @Override
        public Object visit(ASTDestructuringAssignment node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTContinue node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBreak node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTThrow node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTWhileLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTForEachLoop node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTTryCatchFinally node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTUnaryExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTExpressionStatement node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTInvocationExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMultiplicativeExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAdditiveExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTRelationalExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTEqualityExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAndExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTOrExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTOrIfNullExpression node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMethodInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTBlock node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCollectionLiteral node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReference node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAssignment node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTReturn node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTArgument node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTFunctionInvocation node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTConditionalBranching node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTCase node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTMatch node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTDecoratorDeclaration node, Object data) {
            return data;
        }

        @Override
        public Object visit(SimpleNode node, Object data) {
            return data;
        }

        @Override
        public Object visit(ASTerror node, Object data) {
            return data;
        }
    }
}

