/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import gololang.FunctionReference;
import gololang.IO;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.DocIndex;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.ModuleDocumentation;
import org.eclipse.golo.runtime.Warnings;

public class HtmlProcessor
extends AbstractProcessor {
    private Path srcFile;
    private final DocIndex globalIndex = new DocIndex();
    public static final Configuration CONFIG = Configuration.builder().forceExtentedProfile().setCodeBlockEmitter(HtmlProcessor.blockHighlighter()).build();

    @Override
    protected String fileExtension() {
        return "html";
    }

    public DocIndex globalIndex() {
        return this.globalIndex;
    }

    public String linkToDoc(String src, DocumentationElement dst) {
        return this.linkToDoc(this.outputFile(src), dst);
    }

    public String link(DocumentationElement src, DocumentationElement dst) {
        return this.linkToDoc(this.docFile(src), dst);
    }

    private String linkToDoc(Path src, DocumentationElement dst) {
        Path from = src;
        if (from.getParent() != null) {
            from = from.getParent();
        }
        return from.relativize(this.docFile(dst)).toString().replace(FileSystems.getDefault().getSeparator(), "/") + (dst.id().isEmpty() ? "" : "#" + dst.id());
    }

    @Override
    public String render(ModuleDocumentation documentation) throws Throwable {
        FunctionReference template = this.template("template", this.fileExtension());
        this.globalIndex.update(documentation);
        Path doc = this.docFile(documentation);
        if (doc.getParent() != null) {
            doc = doc.getParent();
        }
        return (String)template.invoke(this, documentation, doc.relativize(this.srcFile), this.getSubmodulesOf(documentation));
    }

    @Override
    public void process(Collection<ModuleDocumentation> docs, Path targetFolder) throws Throwable {
        this.setTargetFolder(targetFolder);
        for (ModuleDocumentation doc : docs) {
            this.addModule(doc);
        }
        HashSet<String> donePackages = new HashSet<String>();
        for (ModuleDocumentation doc : docs) {
            if (doc.isEmpty()) {
                this.renderPackage(doc);
            } else {
                this.renderModule(doc);
            }
            donePackages.add(doc.moduleName());
        }
        this.renderRemainingPackages(donePackages);
        this.renderIndex("index");
        this.renderIndex("index-all");
    }

    private void renderRemainingPackages(Set<String> done) throws Throwable {
        for (Map.Entry<String, Set<ModuleDocumentation>> e : this.getPackages()) {
            if (done.contains(e.getKey()) || e.getValue().size() < 1) continue;
            ModuleDocumentation doc = this.createPackageDoc(e.getKey(), e.getValue());
            this.addModule(doc);
            this.renderPackage(doc);
        }
    }

    private ModuleDocumentation createPackageDoc(String name, Set<ModuleDocumentation> modules) throws Throwable {
        ModuleDocumentation doc = ModuleDocumentation.empty(name);
        List docs = modules.stream().map(ModuleDocumentation::sourceFile).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(p -> HtmlProcessor.packageDocumentation(p, name)).distinct().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (docs.size() > 1) {
            Warnings.multiplePackageDescription(name);
        }
        for (Path f : docs) {
            try {
                doc.moduleDocumentation(IO.fileToText(f, null));
                break;
            }
            catch (IOException e) {
            }
        }
        return doc;
    }

    private static Stream<Path> packageDocumentation(Path mod, String name) {
        String basename = PackageAndClass.of(name).className();
        Stream.Builder<Path> docs = Stream.builder();
        Path parent = mod.getParent();
        if (parent != null) {
            if (parent.getFileName().toString().equals(name)) {
                docs.add(mod.resolveSibling("README.md"));
                docs.add(mod.resolveSibling("package.md"));
            } else {
                docs.add(parent.resolve(String.format("%s.md", basename)));
            }
        }
        return docs.build();
    }

    private void renderPackage(ModuleDocumentation documentation) throws Throwable {
        if (documentation != null) {
            FunctionReference template = this.template("package", this.fileExtension());
            IO.textToFile((String)template.invoke(this, documentation, this.getSubmodulesOf(documentation)), this.outputFile(documentation.moduleName()));
        }
    }

    private void renderModule(ModuleDocumentation documentation) throws Throwable {
        String moduleName = documentation.moduleName();
        this.srcFile = this.outputFile(moduleName + "-src");
        IO.textToFile(this.renderSource(moduleName, documentation.sourceFile()), this.srcFile);
        IO.textToFile(this.render(documentation), this.outputFile(moduleName));
    }

    private String renderSource(String moduleName, String filename) throws Throwable {
        FunctionReference template = this.template("src", this.fileExtension());
        String content = IO.fileToText(filename, "UTF-8");
        int nbLines = 0;
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != '\n') continue;
            ++nbLines;
        }
        return (String)template.invoke(moduleName, content, nbLines);
    }

    public static BlockEmitter blockHighlighter() {
        return new BlockEmitter(){

            public void emitBlock(StringBuilder out, List<String> lines, String meta) {
                String language = "".equals(meta) ? "golo" : meta;
                out.append("<pre class=\"listing\">");
                out.append(String.format("<code class=\"lang-%s\" data-lang=\"%s\">", language, language));
                for (String rawLine : lines) {
                    String line = rawLine.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
                    out.append(line);
                    out.append('\n');
                }
                out.append("</code></pre>");
                out.append('\n');
            }
        };
    }

    public static String sectionTitle(int level, DocumentationElement doc, Path src) {
        String permalink = String.format("<a class=\"permalink\" href=\"#%s\" title=\"link to this section\">&#182;</a>", doc.id());
        String srclink = src == null ? "" : String.format("<nav class=\"srclink\"><a href=\"%s#l-%s\" rel=\"source\" title=\"Link to the corresponding source\">Source</a></nav>", src, doc.line());
        return String.format("<h%s id=\"%s\">%s%s</h%s>%s", level, doc.id(), doc.label(), permalink, level, srclink);
    }

    public static String tocItem(DocumentationElement doc) {
        return String.format("<a href=\"#%s\">%s</a>", doc.id(), doc.label());
    }

    public static String moduleListItem(ModuleDocumentation doc, String target) {
        String first;
        StringBuilder item = new StringBuilder("<dt><a");
        if (doc.isEmpty()) {
            item.append(" class=\"package\"");
        }
        item.append(" href=\"").append(target).append("\">").append(doc.moduleName()).append("</a></dt><dd>");
        if (doc.hasDocumentation() && !(first = doc.documentation().trim().split("[.!?]")[0].trim()).isEmpty()) {
            item.append(HtmlProcessor.process(first));
        }
        item.append("</dd>");
        return item.toString();
    }

    public static String process(String documentation, int rootLevel, Configuration configuration) {
        return Processor.process((String)AbstractProcessor.adaptSections(documentation, rootLevel), (Configuration)configuration);
    }

    public static String process(String documentation, int rootLevel) {
        return HtmlProcessor.process(documentation, rootLevel, CONFIG);
    }

    public static String process(String documentation) {
        return HtmlProcessor.process(documentation, 0, CONFIG);
    }
}

