/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.FunctionReference;
import gololang.Messages;
import gololang.Runtime;
import gololang.ir.AbstractInvocation;
import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.CaseStatement;
import gololang.ir.ClassReference;
import gololang.ir.ClosureReference;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.Decorator;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.LoopBreakFlowStatement;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.Member;
import gololang.ir.MethodInvocation;
import gololang.ir.ModuleImport;
import gololang.ir.NamedArgument;
import gololang.ir.NamedAugmentation;
import gololang.ir.Noop;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReferenceTable;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.ThrowStatement;
import gololang.ir.ToplevelElements;
import gololang.ir.TryCatchFinally;
import gololang.ir.UnaryOperation;
import gololang.ir.Union;
import gololang.ir.UnionValue;
import gololang.ir.WhenClause;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.JavaBytecodeStructGenerator;
import org.eclipse.golo.compiler.JavaBytecodeUnionGenerator;
import org.eclipse.golo.compiler.JavaBytecodeUtils;
import org.eclipse.golo.compiler.PackageAndClass;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class JavaBytecodeGenerationGoloIrVisitor
implements GoloIrVisitor {
    private static final String JOBJECT = "java/lang/Object";
    private static final String TOBJECT = "Ljava/lang/Object;";
    private static final Handle FUNCTION_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("FunctionCallSupport", "[Ljava/lang/Object;");
    private static final Handle OPERATOR_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("OperatorSupport", "I");
    private static final Handle METHOD_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("MethodInvocationSupport", "[Ljava/lang/Object;");
    private static final Handle CLASSREF_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClassReferenceSupport", "");
    private static final Handle CLOSUREREF_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClosureReferenceSupport", "Ljava/lang/String;II");
    private static final Handle CLOSURE_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClosureCallSupport", "[Ljava/lang/Object;");
    private static final JavaBytecodeStructGenerator STRUCT_GENERATOR = new JavaBytecodeStructGenerator();
    private static final JavaBytecodeUnionGenerator UNION_GENERATOR = new JavaBytecodeUnionGenerator();
    private static final boolean USE_TCE = Runtime.loadBoolean("golo.optimize.tce", "GOLO_OPTIMIZE_TCE", true);
    private ClassWriter classWriter;
    private String klass;
    private String jvmKlass;
    private MethodVisitor currentMethodVisitor;
    private List<CodeGenerationResult> generationResults;
    private String sourceFilename;
    private Context context;
    private GoloModule currentModule;
    private String returnTypeCast;
    private GoloFunction currentFunction;
    private final Map<GoloFunction, Label> functionLabels = new HashMap<GoloFunction, Label>();

    JavaBytecodeGenerationGoloIrVisitor() {
    }

    private static Handle makeHandle(String methodName, String description) {
        return new Handle(6, "org/eclipse/golo/runtime/" + methodName, "bootstrap", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;" + description + ")Ljava/lang/invoke/CallSite;", false);
    }

    private static RuntimeException invalidElement(GoloElement<?> element) {
        return new IllegalStateException(Messages.prefixed("bug", Messages.message("no_element_remains", element.getClass())));
    }

    public MethodVisitor getMethodVisitor() {
        return this.currentMethodVisitor;
    }

    public void setMethodVisitor(MethodVisitor visitor) {
        this.currentMethodVisitor = visitor;
    }

    public List<CodeGenerationResult> generateBytecode(GoloModule module, String sourceFilename) {
        this.sourceFilename = sourceFilename;
        this.classWriter = new ClassWriter(3);
        this.generationResults = new LinkedList<CodeGenerationResult>();
        this.context = new Context();
        module.accept(this);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), module.getPackageAndClass()));
        return this.generationResults;
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension coll) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(coll);
    }

    @Override
    public void visitMatchExpression(MatchExpression match) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(match);
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(caseStatement);
    }

    @Override
    public void visitWhenClause(WhenClause<?> whenClause) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(whenClause);
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement statement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(statement);
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment statement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(statement);
    }

    @Override
    public void visitToplevelElements(ToplevelElements toplevels) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(toplevels);
    }

    @Override
    public void visitNoop(Noop noop) {
    }

    @Override
    public void visitModule(GoloModule module) {
        this.currentModule = module;
        this.classWriter.visit(52, 33, module.getPackageAndClass().toJVMType(), null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.writeImportMetaData(module.getImports());
        this.klass = module.getPackageAndClass().toString();
        this.jvmKlass = module.getPackageAndClass().toJVMType();
        this.writeAugmentsMetaData();
        this.writeAugmentationApplicationsMetaData();
        module.walk(this);
    }

    @Override
    public void visitModuleImport(ModuleImport moduleImport) {
    }

    @Override
    public void visitLocalReference(LocalReference moduleState) {
        if (moduleState.isModuleState()) {
            String name = moduleState.getName();
            this.classWriter.visitField(10, name, TOBJECT, null, null).visitEnd();
            MethodVisitor mv = this.classWriter.visitMethod(4106, name, "()Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, this.jvmKlass, name, TOBJECT);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = this.classWriter.visitMethod(4106, name, "(Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(179, this.jvmKlass, name, TOBJECT);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void writeMetaData(String name, String[] data) {
        MethodVisitor mv = this.classWriter.visitMethod(4105, "$" + name, "()[Ljava/lang/String;", null, null);
        mv.visitCode();
        JavaBytecodeUtils.loadInteger(mv, data.length);
        mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < data.length; ++i) {
            mv.visitInsn(89);
            JavaBytecodeUtils.loadInteger(mv, i);
            mv.visitLdcInsn((Object)data[i]);
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void writeAugmentationApplicationsMetaData() {
        ArrayList<Augmentation> applications = new ArrayList<Augmentation>(this.currentModule.getAugmentations());
        int applicationsSize = applications.size();
        this.writeMetaData("augmentationApplications", (String[])applications.stream().map(Augmentation::getTarget).map(PackageAndClass::toString).toArray(String[]::new));
        Label defaultLabel = new Label();
        Label[] labels = new Label[applicationsSize];
        int[] keys = new int[applicationsSize];
        String[][] namesArrays = new String[applicationsSize][];
        applications.sort(Comparator.comparingInt(o -> o.getTarget().toString().hashCode()));
        int i = 0;
        for (Augmentation application : applications) {
            labels[i] = new Label();
            keys[i] = application.getTarget().toString().hashCode();
            namesArrays[i] = application.getNames().toArray(new String[application.getNames().size()]);
            ++i;
        }
        MethodVisitor mv = this.classWriter.visitMethod(4105, "$augmentationApplications", "(I)[Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 0);
        mv.visitLookupSwitchInsn(defaultLabel, keys, labels);
        for (i = 0; i < applicationsSize; ++i) {
            mv.visitLabel(labels[i]);
            JavaBytecodeUtils.loadInteger(mv, namesArrays[i].length);
            mv.visitTypeInsn(189, "java/lang/String");
            for (int j = 0; j < namesArrays[i].length; ++j) {
                mv.visitInsn(89);
                JavaBytecodeUtils.loadInteger(mv, j);
                mv.visitLdcInsn((Object)namesArrays[i][j]);
                mv.visitInsn(83);
            }
            mv.visitInsn(176);
        }
        mv.visitLabel(defaultLabel);
        JavaBytecodeUtils.loadInteger(mv, 0);
        mv.visitTypeInsn(189, "java/lang/String");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void writeImportMetaData(Set<ModuleImport> imports) {
        this.writeMetaData("imports", (String[])imports.stream().map(ModuleImport::getPackageAndClass).map(PackageAndClass::toString).toArray(String[]::new));
    }

    private void writeAugmentsMetaData() {
        this.writeMetaData("augmentations", (String[])this.currentModule.getAugmentations().stream().map(Augmentation::getTarget).map(PackageAndClass::toString).toArray(String[]::new));
    }

    @Override
    public void visitStruct(Struct struct) {
        this.generationResults.add(STRUCT_GENERATOR.compile(struct, this.sourceFilename));
    }

    @Override
    public void visitUnion(Union union) {
        this.generationResults.addAll(UNION_GENERATOR.compile(union, this.sourceFilename));
    }

    @Override
    public void visitUnionValue(UnionValue value) {
    }

    @Override
    public void visitAugmentation(Augmentation augmentation) {
        this.generateAugmentationBytecode(augmentation.getTarget(), augmentation.getFunctions());
    }

    @Override
    public void visitNamedAugmentation(NamedAugmentation namedAugmentation) {
        this.generateAugmentationBytecode(namedAugmentation.getPackageAndClass(), namedAugmentation.getFunctions());
    }

    private void generateAugmentationBytecode(PackageAndClass target, Collection<GoloFunction> functions) {
        if (functions.isEmpty()) {
            return;
        }
        ClassWriter mainClassWriter = this.classWriter;
        String mangledClass = target.mangledName();
        PackageAndClass packageAndClass = this.currentModule.getPackageAndClass().createInnerClass(mangledClass);
        String augmentationClassInternalName = packageAndClass.toJVMType();
        String outerName = this.currentModule.getPackageAndClass().toJVMType();
        mainClassWriter.visitInnerClass(augmentationClassInternalName, outerName, mangledClass, 9);
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(52, 33, augmentationClassInternalName, null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.classWriter.visitOuterClass(outerName, null, null);
        for (GoloFunction function : functions) {
            function.accept(this);
        }
        HashSet<ModuleImport> imports = new HashSet<ModuleImport>(this.currentModule.getImports());
        imports.add(ModuleImport.of(this.currentModule.getPackageAndClass()));
        this.writeImportMetaData(imports);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), packageAndClass));
        this.classWriter = mainClassWriter;
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.currentMethodVisitor = this.classWriter.visitMethod(this.functionFlags(function), function.getName(), this.functionSignature(function), null, null);
        if (function.isDecorated()) {
            AnnotationVisitor annotation = this.currentMethodVisitor.visitAnnotation("Lgololang/annotations/DecoratedBy;", true);
            annotation.visit("value", (Object)function.getDecoratorRef());
            annotation.visitEnd();
        }
        for (String parameter : function.getParameterNames()) {
            this.currentMethodVisitor.visitParameter(parameter, 16);
        }
        this.currentMethodVisitor.visitCode();
        this.functionLabels.put(function, JavaBytecodeUtils.visitLine(function, this.currentMethodVisitor));
        this.currentFunction = function;
        function.walk(this);
        this.returnTypeCast = null;
        this.currentFunction = null;
        if (function.isModuleInit()) {
            this.currentMethodVisitor.visitInsn(177);
        }
        this.currentMethodVisitor.visitMaxs(0, 0);
        this.currentMethodVisitor.visitEnd();
    }

    private int functionFlags(GoloFunction function) {
        int accessFlags = 8 | (function.isLocal() ? 2 : 1);
        if (function.isSynthetic() || function.isDecorator()) {
            accessFlags |= 0x1000;
        }
        if (function.isVarargs()) {
            accessFlags |= 0x80;
        }
        return accessFlags;
    }

    private String functionSignature(GoloFunction function) {
        if (function.isMain()) {
            return "([Ljava/lang/String;)V";
        }
        if (function.isModuleInit()) {
            return "()V";
        }
        MethodType signature = function.isVarargs() ? MethodType.genericMethodType(function.getArity() - 1, true) : MethodType.genericMethodType(function.getArity());
        return signature.toMethodDescriptorString();
    }

    private String goloFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity).toMethodDescriptorString();
    }

    @Override
    public void visitDecorator(Decorator deco) {
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable referenceTable = block.getReferenceTable();
        this.context.referenceTableStack.push(referenceTable);
        Label blockStart = new Label();
        Label blockEnd = new Label();
        this.currentMethodVisitor.visitLabel(blockStart);
        for (GoloStatement<?> statement : block.getStatements()) {
            JavaBytecodeUtils.visitLine(statement, this.currentMethodVisitor);
            statement.accept(this);
            this.insertMissingPop(statement);
        }
        this.currentMethodVisitor.visitLabel(blockEnd);
        for (LocalReference localReference : referenceTable.ownedReferences()) {
            if (localReference.isModuleState()) continue;
            this.currentMethodVisitor.visitLocalVariable(localReference.getName(), TOBJECT, null, blockStart, blockEnd, localReference.getIndex());
        }
        this.context.referenceTableStack.pop();
    }

    private void insertMissingPop(GoloStatement<?> statement) {
        BinaryOperation operation;
        Class<?> statementClass = statement.getClass();
        if (statementClass == FunctionInvocation.class) {
            this.currentMethodVisitor.visitInsn(87);
        } else if (statementClass == BinaryOperation.class && (operation = (BinaryOperation)statement).isMethodCall()) {
            this.currentMethodVisitor.visitInsn(87);
        }
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        Object value = constantStatement.value();
        if (value == null) {
            this.currentMethodVisitor.visitInsn(1);
            return;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, i);
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            return;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            JavaBytecodeUtils.loadLong(this.currentMethodVisitor, l);
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
            return;
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, b ? 1 : 0);
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            return;
        }
        if (value instanceof BigDecimal) {
            this.currentMethodVisitor.visitTypeInsn(187, "java/math/BigDecimal");
            this.currentMethodVisitor.visitInsn(89);
            this.currentMethodVisitor.visitLdcInsn((Object)value.toString());
            this.currentMethodVisitor.visitMethodInsn(183, "java/math/BigDecimal", "<init>", "(Ljava/lang/String;)V", false);
            return;
        }
        if (value instanceof BigInteger) {
            this.currentMethodVisitor.visitTypeInsn(187, "java/math/BigInteger");
            this.currentMethodVisitor.visitInsn(89);
            this.currentMethodVisitor.visitLdcInsn((Object)value.toString());
            this.currentMethodVisitor.visitMethodInsn(183, "java/math/BigInteger", "<init>", "(Ljava/lang/String;)V", false);
            return;
        }
        if (value instanceof String) {
            this.currentMethodVisitor.visitLdcInsn(value);
            return;
        }
        if (value instanceof Character) {
            JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, ((Character)value).charValue());
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
            return;
        }
        if (value instanceof ClassReference) {
            this.currentMethodVisitor.visitInvokeDynamicInsn(((ClassReference)value).toJVMType(), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            this.currentMethodVisitor.visitLdcInsn((Object)d);
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            return;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            this.currentMethodVisitor.visitLdcInsn((Object)Float.valueOf(f));
            this.currentMethodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
            return;
        }
        throw new IllegalArgumentException("Constants of type " + value.getClass() + " cannot be handled.");
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        GoloStatement<?> expr = returnStatement.expression();
        if (this.isRecursiveTailCall(expr)) {
            this.storeInvocationArguments((FunctionInvocation)expr, this.currentFunction);
            this.currentMethodVisitor.visitJumpInsn(167, this.functionLabels.get(this.currentFunction));
            return;
        }
        if (expr != null) {
            expr.accept(this);
        }
        if (returnStatement.isReturningVoid()) {
            this.currentMethodVisitor.visitInsn(177);
        } else {
            if (this.returnTypeCast != null) {
                this.currentMethodVisitor.visitTypeInsn(192, this.returnTypeCast);
            }
            this.currentMethodVisitor.visitInsn(176);
        }
    }

    private boolean isRecursiveTailCall(GoloStatement<?> statement) {
        if (USE_TCE && statement instanceof FunctionInvocation) {
            FunctionInvocation invoke = (FunctionInvocation)statement;
            if (this.currentFunction.isDecorated()) {
                return false;
            }
            if (invoke.isOnReference()) {
                return invoke.getName().equals(this.currentFunction.getSyntheticSelfName()) && invoke.getArity() == this.currentFunction.getArity() - this.currentFunction.getSyntheticParameterCount();
            }
            return invoke.getName().equals(this.currentFunction.getName()) && invoke.getArity() == this.currentFunction.getArity();
        }
        return false;
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.walk(this);
        this.currentMethodVisitor.visitTypeInsn(192, "java/lang/Throwable");
        this.currentMethodVisitor.visitInsn(191);
    }

    private List<String> visitInvocationArguments(AbstractInvocation<?> invocation) {
        ArrayList<String> argumentNames = new ArrayList<String>();
        for (GoloElement<?> argument : invocation.getArguments()) {
            if (invocation.usesNamedArguments()) {
                NamedArgument namedArgument = (NamedArgument)argument;
                argumentNames.add(namedArgument.getName());
                argument = namedArgument.expression();
            }
            argument.accept(this);
        }
        return argumentNames;
    }

    private void storeInvocationArguments(AbstractInvocation<?> invocation, GoloFunction function) {
        int offset = function.getBlock().getReferenceTable().size();
        this.storeRegularInvocationArguments(JavaBytecodeGenerationGoloIrVisitor.reorderArguments(invocation.getArguments(), function.getParameterNames()), offset);
        this.reloadNextCallArguments(function.getArity(), offset, function.getSyntheticParameterCount());
    }

    private void reloadNextCallArguments(int paramNumber, int tmpOffset, int paramOffset) {
        for (int i = 0; i < paramNumber - paramOffset; ++i) {
            this.currentMethodVisitor.visitVarInsn(25, i + tmpOffset);
            this.currentMethodVisitor.visitVarInsn(58, i + paramOffset);
        }
    }

    private static List<GoloElement<?>> reorderArguments(List<GoloElement<?>> arguments, List<String> parameterNames) {
        if (!arguments.stream().allMatch(e -> e instanceof NamedArgument)) {
            return arguments;
        }
        ArrayList ordered = new ArrayList(arguments);
        for (GoloElement<?> arg : arguments) {
            NamedArgument named = (NamedArgument)arg;
            ordered.set(parameterNames.indexOf(named.getName()), named.expression());
        }
        return ordered;
    }

    private void storeRegularInvocationArguments(List<GoloElement<?>> arguments, int offset) {
        for (int i = 0; i < arguments.size(); ++i) {
            arguments.get(i).accept(this);
            this.currentMethodVisitor.visitVarInsn(58, i + offset);
        }
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        String name = functionInvocation.getName().replaceAll("\\.", "#");
        String typeDef = this.goloFunctionSignature(functionInvocation.getArity());
        Handle handle = FUNCTION_INVOCATION_HANDLE;
        ArrayList<Object> bootstrapArgs = new ArrayList<Object>();
        bootstrapArgs.add(functionInvocation.isConstant() ? 1 : 0);
        if (functionInvocation.isOnReference()) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            this.currentMethodVisitor.visitVarInsn(25, table.get(functionInvocation.getName()).getIndex());
        }
        if (functionInvocation.isOnModuleState()) {
            ReferenceLookup.of(functionInvocation.getName()).accept(this);
        }
        if (functionInvocation.isAnonymous() || functionInvocation.isOnReference() || functionInvocation.isOnModuleState()) {
            this.currentMethodVisitor.visitTypeInsn(192, "gololang/FunctionReference");
            MethodType type = MethodType.genericMethodType(functionInvocation.getArity() + 1).changeParameterType(0, FunctionReference.class);
            typeDef = type.toMethodDescriptorString();
            handle = CLOSURE_INVOCATION_HANDLE;
        }
        List<String> argumentNames = this.visitInvocationArguments(functionInvocation);
        bootstrapArgs.addAll(argumentNames);
        this.currentMethodVisitor.visitInvokeDynamicInsn(name, typeDef, handle, bootstrapArgs.toArray());
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        ArrayList<Object> bootstrapArgs = new ArrayList<Object>();
        bootstrapArgs.add(methodInvocation.isNullSafeGuarded() ? 1 : 0);
        List<String> argumentNames = this.visitInvocationArguments(methodInvocation);
        bootstrapArgs.addAll(argumentNames);
        this.currentMethodVisitor.visitInvokeDynamicInsn(methodInvocation.getName().replaceAll("\\.", "#"), this.goloFunctionSignature(methodInvocation.getArity() + 1), METHOD_INVOCATION_HANDLE, bootstrapArgs.toArray());
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        assignmentStatement.walk(this);
        LocalReference reference = assignmentStatement.getLocalReference();
        if (reference.isModuleState()) {
            this.currentMethodVisitor.visitInvokeDynamicInsn((this.klass + "." + reference.getName()).replaceAll("\\.", "#"), "(Ljava/lang/Object;)V", FUNCTION_INVOCATION_HANDLE, new Object[]{0});
        } else {
            this.currentMethodVisitor.visitVarInsn(58, reference.getIndex());
        }
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference reference = referenceLookup.resolveIn((ReferenceTable)this.context.referenceTableStack.peek());
        if (reference.isModuleState()) {
            this.currentMethodVisitor.visitInvokeDynamicInsn((this.klass + "." + referenceLookup.getName()).replaceAll("\\.", "#"), "()Ljava/lang/Object;", FUNCTION_INVOCATION_HANDLE, new Object[]{0});
        } else {
            this.currentMethodVisitor.visitVarInsn(25, reference.getIndex());
        }
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        Label branchingElseLabel = new Label();
        Label branchingExitLabel = new Label();
        conditionalBranching.getCondition().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(153, branchingElseLabel);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.currentMethodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.currentMethodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getFalseBlock().accept(this);
            this.currentMethodVisitor.visitLabel(branchingExitLabel);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.currentMethodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.currentMethodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getElseConditionalBranching().accept(this);
            this.currentMethodVisitor.visitLabel(branchingExitLabel);
        } else {
            this.currentMethodVisitor.visitLabel(branchingElseLabel);
        }
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        Label loopStart = new Label();
        Label loopEnd = new Label();
        this.context.loopStartMap.put(loopStatement, loopStart);
        this.context.loopEndMap.put(loopStatement, loopEnd);
        if (loopStatement.hasInitStatement()) {
            loopStatement.init().accept(this);
        }
        this.currentMethodVisitor.visitLabel(loopStart);
        loopStatement.condition().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(153, loopEnd);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.post().accept(this);
        }
        this.currentMethodVisitor.visitJumpInsn(167, loopStart);
        this.currentMethodVisitor.visitLabel(loopEnd);
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        Label jumpTarget = LoopBreakFlowStatement.Type.BREAK.equals((Object)loopBreakFlowStatement.getType()) ? (Label)this.context.loopEndMap.get(loopBreakFlowStatement.getEnclosingLoop()) : (Label)this.context.loopStartMap.get(loopBreakFlowStatement.getEnclosingLoop());
        this.currentMethodVisitor.visitLdcInsn((Object)0);
        this.currentMethodVisitor.visitJumpInsn(153, jumpTarget);
    }

    @Override
    public void visitNamedArgument(NamedArgument namedArgument) {
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(collectionLiteral);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchStart = new Label();
        Label catchEnd = new Label();
        Label rethrowStart = null;
        Label rethrowEnd = null;
        if (tryCatchFinally.isTryCatchFinally()) {
            rethrowStart = new Label();
            rethrowEnd = new Label();
        }
        this.currentMethodVisitor.visitLabel(tryStart);
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            this.currentMethodVisitor.visitJumpInsn(167, catchEnd);
        }
        this.currentMethodVisitor.visitTryCatchBlock(tryStart, tryEnd, catchStart, null);
        this.currentMethodVisitor.visitLabel(tryEnd);
        if (tryCatchFinally.isTryFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.currentMethodVisitor.visitJumpInsn(167, catchEnd);
        }
        if (tryCatchFinally.isTryCatchFinally()) {
            this.currentMethodVisitor.visitTryCatchBlock(catchStart, catchEnd, rethrowStart, null);
        }
        this.currentMethodVisitor.visitLabel(catchStart);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            Block catchBlock = tryCatchFinally.getCatchBlock();
            int exceptionRefIndex = catchBlock.getReferenceTable().get(tryCatchFinally.getExceptionId()).getIndex();
            this.currentMethodVisitor.visitVarInsn(58, exceptionRefIndex);
            tryCatchFinally.getCatchBlock().accept(this);
        } else {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.currentMethodVisitor.visitInsn(191);
        }
        this.currentMethodVisitor.visitLabel(catchEnd);
        if (tryCatchFinally.isTryCatchFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.currentMethodVisitor.visitJumpInsn(167, rethrowEnd);
            this.currentMethodVisitor.visitLabel(rethrowStart);
            tryCatchFinally.getFinallyBlock().accept(this);
            this.currentMethodVisitor.visitInsn(191);
            this.currentMethodVisitor.visitLabel(rethrowEnd);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        boolean isVarArgs = target.isVarargs();
        int arity = isVarArgs ? target.getArity() - 1 : target.getArity();
        int syntheticCount = target.getSyntheticParameterCount();
        this.currentMethodVisitor.visitInvokeDynamicInsn(target.getName(), MethodType.methodType(FunctionReference.class).toMethodDescriptorString(), CLOSUREREF_HANDLE, new Object[]{this.klass, arity, isVarArgs});
        if (syntheticCount > 0) {
            String[] refs = closureReference.getCapturedReferenceNames().toArray(new String[syntheticCount]);
            JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, 0);
            JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, syntheticCount);
            this.currentMethodVisitor.visitTypeInsn(189, JOBJECT);
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            for (int i = 0; i < syntheticCount; ++i) {
                this.currentMethodVisitor.visitInsn(89);
                JavaBytecodeUtils.loadInteger(this.currentMethodVisitor, i);
                this.currentMethodVisitor.visitVarInsn(25, table.get(refs[i]).getIndex());
                this.currentMethodVisitor.visitInsn(83);
            }
            this.currentMethodVisitor.visitMethodInsn(182, "gololang/FunctionReference", "insertArguments", "(I[Ljava/lang/Object;)Lgololang/FunctionReference;", false);
            if (isVarArgs) {
                this.currentMethodVisitor.visitLdcInsn((Object)Type.getType(Object[].class));
                this.currentMethodVisitor.visitMethodInsn(182, "gololang/FunctionReference", "asVarargsCollector", "(Ljava/lang/Class;)Lgololang/FunctionReference;", false);
            }
        }
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        switch (binaryOperation.getType()) {
            case AND: {
                this.andOperator(binaryOperation);
                break;
            }
            case OR: {
                this.orOperator(binaryOperation);
                break;
            }
            case ORIFNULL: {
                this.orIfNullOperator(binaryOperation);
                break;
            }
            default: {
                binaryOperation.walk(this);
                this.genericBinaryOperator(binaryOperation);
            }
        }
    }

    private void genericBinaryOperator(BinaryOperation binaryOperation) {
        if (!binaryOperation.isMethodCall()) {
            String name = binaryOperation.getType().name().toLowerCase();
            this.currentMethodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(2), OPERATOR_HANDLE, new Object[]{2});
        }
    }

    private void orIfNullOperator(BinaryOperation binaryOperation) {
        int idx = ((ReferenceTable)this.context.referenceTableStack.peek()).size();
        Label nullLabel = new Label();
        Label exitLabel = new Label();
        binaryOperation.left().accept(this);
        this.currentMethodVisitor.visitVarInsn(58, idx);
        this.currentMethodVisitor.visitVarInsn(25, idx);
        this.currentMethodVisitor.visitJumpInsn(198, nullLabel);
        this.currentMethodVisitor.visitJumpInsn(167, exitLabel);
        this.currentMethodVisitor.visitLabel(nullLabel);
        binaryOperation.right().accept(this);
        this.currentMethodVisitor.visitVarInsn(58, idx);
        this.currentMethodVisitor.visitLabel(exitLabel);
        this.currentMethodVisitor.visitVarInsn(25, idx);
    }

    private void orOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label trueLabel = new Label();
        binaryOperation.left().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(154, trueLabel);
        binaryOperation.right().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(154, trueLabel);
        this.asmFalseObject();
        this.currentMethodVisitor.visitJumpInsn(167, exitLabel);
        this.currentMethodVisitor.visitLabel(trueLabel);
        this.asmTrueObject();
        this.currentMethodVisitor.visitLabel(exitLabel);
    }

    private void andOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label falseLabel = new Label();
        binaryOperation.left().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(153, falseLabel);
        binaryOperation.right().accept(this);
        this.asmBooleanValue();
        this.currentMethodVisitor.visitJumpInsn(153, falseLabel);
        this.asmTrueObject();
        this.currentMethodVisitor.visitJumpInsn(167, exitLabel);
        this.currentMethodVisitor.visitLabel(falseLabel);
        this.asmFalseObject();
        this.currentMethodVisitor.visitLabel(exitLabel);
    }

    private void asmFalseObject() {
        this.currentMethodVisitor.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
    }

    private void asmTrueObject() {
        this.currentMethodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
    }

    private void asmBooleanValue() {
        this.currentMethodVisitor.visitTypeInsn(192, "java/lang/Boolean");
        this.currentMethodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        String name = unaryOperation.getType().name().toLowerCase();
        unaryOperation.walk(this);
        this.currentMethodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(1), OPERATOR_HANDLE, new Object[]{1});
    }

    @Override
    public void visitMember(Member member) {
    }

    private static final class Context {
        private final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        private final Map<LoopStatement, Label> loopStartMap = new HashMap<LoopStatement, Label>();
        private final Map<LoopStatement, Label> loopEndMap = new HashMap<LoopStatement, Label>();

        private Context() {
        }
    }
}

