/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.AssignmentStatement;
import gololang.ir.Block;
import gololang.ir.BlockContainer;
import gololang.ir.ClosureReference;
import gololang.ir.Decorator;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.LocalReference;
import gololang.ir.NamedElement;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReturnStatement;
import gololang.ir.ToplevelGoloElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.golo.compiler.SymbolGenerator;

public final class GoloFunction
extends ExpressionStatement<GoloFunction>
implements BlockContainer<GoloFunction>,
ToplevelGoloElement,
NamedElement {
    private static final SymbolGenerator SYMBOLS = new SymbolGenerator("golo.ir.function");
    private String name;
    private boolean isLocal = false;
    private Scope scope = Scope.MODULE;
    private final List<String> parameterNames = new LinkedList<String>();
    private final List<String> syntheticParameterNames = new LinkedList<String>();
    private boolean varargs = false;
    private Block block;
    private boolean synthetic = false;
    private boolean decorator = false;
    private String syntheticSelfName = null;
    private String decoratorRef = null;
    private final LinkedList<Decorator> decorators = new LinkedList();

    @Override
    protected GoloFunction self() {
        return this;
    }

    private GoloFunction() {
        this.block(Block.empty());
    }

    private GoloFunction(GoloFunction function) {
        this.name = function.name;
        this.isLocal = function.isLocal;
        this.scope = function.scope;
        this.varargs = function.varargs;
        this.synthetic = function.synthetic;
        this.decorator = function.decorator;
        this.syntheticSelfName = function.syntheticSelfName;
        this.decoratorRef = function.decoratorRef;
        this.parameterNames.addAll(function.parameterNames);
        this.syntheticParameterNames.addAll(function.syntheticParameterNames);
        this.documentation(function.documentation());
        this.decorators.addAll(function.decorators);
        this.block(function.block);
        this.positionInSourceCode(function.positionInSourceCode());
    }

    public static GoloFunction function(Object name) {
        if (name instanceof GoloFunction) {
            return new GoloFunction((GoloFunction)name);
        }
        if (name == null) {
            return new GoloFunction();
        }
        return new GoloFunction().name(name.toString());
    }

    public GoloFunction name(String n) {
        this.name = n;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isMain() {
        return "main".equals(this.name) && this.getArity() == 1;
    }

    public boolean isModuleInit() {
        return "<clinit>".equals(this.name);
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public GoloFunction synthetic(boolean s) {
        this.synthetic = s;
        return this;
    }

    public GoloFunction synthetic() {
        return this.synthetic(true);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public GoloFunction decorator() {
        return this.decorator(true);
    }

    public GoloFunction decorator(boolean d) {
        this.decorator = d;
        return this;
    }

    public boolean isDecorator() {
        return this.decorator;
    }

    public GoloFunction local() {
        return this.local(true);
    }

    public GoloFunction local(boolean isLocal) {
        this.isLocal = isLocal;
        return this;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public GoloFunction inScope(Scope s) {
        this.scope = s;
        return this;
    }

    public GoloFunction inAugment() {
        return this.inAugment(true);
    }

    public GoloFunction inAugment(boolean isInAugment) {
        if (isInAugment) {
            this.scope = Scope.AUGMENT;
        }
        return this;
    }

    public boolean isInAugment() {
        return Scope.AUGMENT.equals((Object)this.scope);
    }

    public boolean isInModule() {
        return Scope.MODULE.equals((Object)this.scope);
    }

    public GoloFunction asClosure() {
        this.scope = Scope.CLOSURE;
        return this;
    }

    @Override
    public GoloFunction block(Object block) {
        this.block = this.makeParentOf(Block.of(block));
        for (String param : this.parameterNames) {
            this.addParameterToBlockReferences(param);
        }
        return this;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public GoloFunction returns(Object expression) {
        this.block.add(ReturnStatement.of(expression));
        return this;
    }

    public void insertMissingReturnStatement() {
        if (!this.block.hasReturn() && !this.isModuleInit()) {
            if (this.isMain()) {
                this.block.add(ReturnStatement.empty().synthetic());
            } else {
                this.block.add(ReturnStatement.of(null).synthetic());
            }
        }
    }

    public GoloFunction varargs(boolean isVarargs) {
        this.varargs = isVarargs;
        return this;
    }

    public GoloFunction varargs() {
        return this.varargs(true);
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public int getArity() {
        return this.parameterNames.size() + this.syntheticParameterNames.size();
    }

    public GoloFunction withParameters(Object ... names) {
        return this.withParameters(Arrays.asList(names));
    }

    public GoloFunction withParameters(Collection<?> names) {
        for (Object name : names) {
            this.addParameterToBlockReferences(name.toString());
            this.parameterNames.add(name.toString());
        }
        return this;
    }

    private void addParameterToBlockReferences(String name) {
        this.block.getReferenceTable().add(LocalReference.of(name));
    }

    public int getSyntheticParameterCount() {
        return this.syntheticParameterNames.size();
    }

    public List<String> getParameterNames() {
        LinkedList<String> list = new LinkedList<String>(this.syntheticParameterNames);
        list.addAll(this.parameterNames);
        return list;
    }

    public Collection<String> getSyntheticParameterNames() {
        return Collections.unmodifiableList(this.syntheticParameterNames);
    }

    public void addSyntheticParameters(Set<String> names) {
        HashSet<String> existing = new HashSet<String>(this.getParameterNames());
        for (String name : names) {
            LocalReference ref;
            if (existing.contains(name) || name.equals(this.syntheticSelfName) || (ref = this.block.getReferenceTable().get(name)) != null && ref.isModuleState()) continue;
            this.syntheticParameterNames.add(name);
        }
    }

    public String getSyntheticSelfName() {
        return this.syntheticSelfName;
    }

    public LocalReference getSyntheticSelfReference() {
        return this.block.getReferenceTable().get(this.syntheticSelfName);
    }

    public void setSyntheticSelfName(String name) {
        if (this.syntheticParameterNames.contains(name)) {
            this.syntheticParameterNames.remove(name);
            this.syntheticSelfName = name;
        }
    }

    public void captureClosedReference() {
        if (this.synthetic && this.syntheticSelfName != null) {
            this.block.prepend(AssignmentStatement.create(this.getSyntheticSelfReference(), this.asClosureReference(), true));
        }
    }

    public GoloFunction decoratedWith(Object ... decorators) {
        for (Object deco : decorators) {
            this.addDecorator(Decorator.of(deco));
        }
        return this;
    }

    public boolean isDecorated() {
        return !this.decorators.isEmpty();
    }

    public String getDecoratorRef() {
        return this.decoratorRef;
    }

    public void addDecorator(Decorator decorator) {
        this.decorators.add(this.makeParentOf(decorator));
    }

    public void removeDecorator(Decorator decorator) {
        this.decorators.remove(decorator);
    }

    public List<Decorator> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public GoloFunction createDecorator() {
        ExpressionStatement expr = ReferenceLookup.of("__$$_original");
        for (Decorator decorator : this.getDecorators()) {
            expr = decorator.wrapExpression(expr);
        }
        this.decoratorRef = SYMBOLS.next(this.name + "_decorator");
        return GoloFunction.function(this.decoratorRef).decorator().inScope(this.scope).withParameters("__$$_original").returns(expr);
    }

    public ClosureReference asClosureReference() {
        if (this.scope != Scope.CLOSURE) {
            throw new IllegalStateException("Can't get a closure reference of a non-closure function");
        }
        return new ClosureReference(this);
    }

    public GoloFunction sameSignature() {
        return GoloFunction.function(this.name).local(this.isLocal).inScope(this.scope).withParameters(this.parameterNames).varargs(this.varargs).synthetic(true);
    }

    public Object[] parametersAsRefs() {
        return this.parameterNames.stream().map(ReferenceLookup::of).toArray();
    }

    public String toString() {
        return String.format("Function{name=%s, arity=%d, vararg=%s, synthetic=%s, self=%s}", this.getName(), this.getArity(), this.isVarargs(), this.synthetic, this.syntheticSelfName);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitFunction(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.decorators);
        children.add((Decorator)((Object)this.block));
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        throw this.cantReplace();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getArity(), this.varargs);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoloFunction other = (GoloFunction)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.varargs != other.varargs) {
            return false;
        }
        return this.getArity() == other.getArity();
    }

    public static String uniqueName() {
        return SYMBOLS.next();
    }

    public static String uniqueName(Object base) {
        return SYMBOLS.next(base.toString());
    }

    public static enum Scope {
        MODULE,
        AUGMENT,
        CLOSURE;

    }
}

