/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Block;
import gololang.ir.BlockContainer;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.ReferencesHolder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ForEachLoopStatement
extends GoloStatement<ForEachLoopStatement>
implements BlockContainer<ForEachLoopStatement>,
ReferencesHolder {
    private Block block = Block.empty();
    private ExpressionStatement<?> iterable;
    private final List<LocalReference> valueRefs = new LinkedList<LocalReference>();
    private ExpressionStatement<?> whenClause;
    private boolean isVarargs = false;

    private ForEachLoopStatement() {
    }

    public static ForEachLoopStatement create(boolean varargs, Object iterable, Object when, Object block, Object ... vars) {
        ForEachLoopStatement loop = new ForEachLoopStatement();
        for (Object v : vars) {
            loop.var(v);
        }
        return loop.varargs(varargs).when(when).in(iterable).block(block);
    }

    public static ForEachLoopStatement create() {
        return new ForEachLoopStatement();
    }

    @Override
    public ForEachLoopStatement block(Object block) {
        this.block = this.makeParentOf(Block.of(block));
        return this;
    }

    @Override
    protected ForEachLoopStatement self() {
        return this;
    }

    public ForEachLoopStatement in(Object iterable) {
        this.iterable = ExpressionStatement.of(iterable);
        return this;
    }

    public ForEachLoopStatement varargs(boolean b) {
        this.isVarargs = b;
        return this;
    }

    public ForEachLoopStatement var(Object varRef) {
        this.valueRefs.add(LocalReference.of(varRef).variable());
        return this;
    }

    public ForEachLoopStatement when(Object clause) {
        this.whenClause = clause != null ? ExpressionStatement.of(clause) : null;
        return this;
    }

    public ExpressionStatement<?> getIterable() {
        return this.iterable;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public boolean isDestructuring() {
        return this.valueRefs.size() > 1;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public LocalReference getLocalReference() {
        return this.valueRefs.get(0);
    }

    @Override
    public LocalReference[] getReferences() {
        return this.valueRefs.toArray(new LocalReference[this.valueRefs.size()]);
    }

    @Override
    public int getReferencesCount() {
        return this.valueRefs.size();
    }

    public boolean hasWhenClause() {
        return this.whenClause != null;
    }

    public ExpressionStatement<?> getWhenClause() {
        return this.whenClause;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitForEachLoopStatement(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.valueRefs);
        children.add(this.iterable);
        if (this.whenClause != null) {
            children.add(this.whenClause);
        }
        children.add((LocalReference)((Object)this.block));
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (Objects.equals(this.iterable, original)) {
            this.in(newElement);
        } else if (Objects.equals(this.whenClause, original)) {
            this.when(newElement);
        } else if (Objects.equals(this.block, original)) {
            this.block(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

