/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.DynamicObject;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.WeakHashMap;
import org.eclipse.golo.runtime.ArrayMethodFinder;
import org.eclipse.golo.runtime.AugmentationMethodFinder;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.PropertyMethodFinder;
import org.eclipse.golo.runtime.RegularMethodFinder;

public final class MethodInvocationSupport {
    private static final MethodHandle CLASS_GUARD;
    private static final MethodHandle FALLBACK;
    private static final MethodHandle RESET_FALLBACK;
    private static final MethodHandle VTABLE_LOOKUP;
    private static final MethodHandle OVERLOADED_GUARD_GENERIC;
    private static final MethodHandle OVERLOADED_GUARD_1;
    private static final MethodHandle OVERLOADED_GUARD_2;
    private static final MethodHandle OVERLOADED_GUARD_3;
    private static final MethodHandle OVERLOADED_GUARD_4;
    private static final HashSet<String> DYNAMIC_OBJECT_RESERVED_METHOD_NAMES;

    private MethodInvocationSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, Object ... bsmArgs) {
        boolean nullSafeGuarded = (Integer)bsmArgs[0] == 1;
        String[] argumentNames = new String[bsmArgs.length - 1];
        for (int i = 0; i < bsmArgs.length - 1; ++i) {
            argumentNames[i] = (String)bsmArgs[i + 1];
        }
        InlineCache callSite = new InlineCache(caller, name, type, nullSafeGuarded, argumentNames);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.resetFallback = RESET_FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean classGuard(Class<?> expected, Object receiver) {
        return receiver.getClass() == expected;
    }

    public static boolean overloadedGuard_generic(Class<?>[] types2, Object[] arguments) {
        if (arguments[0].getClass() != types2[0]) {
            return false;
        }
        for (int i = 1; i < types2.length; ++i) {
            if (arguments[i] == null || arguments[i].getClass() == types2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean overloadedGuard_1(Class<?> t1, Class<?> t2, Object receiver, Object arg) {
        return receiver.getClass() == t1 && (arg == null || arg.getClass() == t2);
    }

    public static boolean overloadedGuard_2(Class<?> t1, Class<?> t2, Class<?> t3, Object receiver, Object arg1, Object arg2) {
        return !(receiver.getClass() != t1 || arg1 != null && arg1.getClass() != t2 || arg2 != null && arg2.getClass() != t3);
    }

    public static boolean overloadedGuard_3(Class<?> t1, Class<?> t2, Class<?> t3, Class<?> t4, Object receiver, Object arg1, Object arg2, Object arg3) {
        return !(receiver.getClass() != t1 || arg1 != null && arg1.getClass() != t2 || arg2 != null && arg2.getClass() != t3 || arg3 != null && arg3.getClass() != t4);
    }

    public static boolean overloadedGuard_4(Class<?> t1, Class<?> t2, Class<?> t3, Class<?> t4, Class<?> t5, Object receiver, Object arg1, Object arg2, Object arg3, Object arg4) {
        return !(receiver.getClass() != t1 || arg1 != null && arg1.getClass() != t2 || arg2 != null && arg2.getClass() != t3 || arg3 != null && arg3.getClass() != t4 || arg4 != null && arg4.getClass() != t5);
    }

    public static MethodHandle vtableLookup(InlineCache inlineCache, Object[] args) {
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = inlineCache.vtable.get(receiverClass);
        if (target == null) {
            target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
            inlineCache.vtable.put(receiverClass, target);
        }
        return target;
    }

    private static MethodHandle lookupTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        MethodInvocation invocation = inlineCache.toMethodInvocation(args);
        if (receiverClass.isArray()) {
            return new ArrayMethodFinder(invocation, inlineCache.callerLookup).find();
        }
        if (MethodInvocationSupport.isCallOnDynamicObject(inlineCache, args[0])) {
            DynamicObject dynamicObject = (DynamicObject)args[0];
            return dynamicObject.invoker(inlineCache.name, inlineCache.type());
        }
        return MethodInvocationSupport.findTarget(invocation, inlineCache);
    }

    public static Object resetFallback(InlineCache inlineCache, Object[] args) throws Throwable {
        inlineCache.depth = 0;
        return MethodInvocationSupport.fallback(inlineCache, args);
    }

    public static Object fallback(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.isMegaMorphic()) {
            return MethodInvocationSupport.installVTableDispatch(inlineCache, args);
        }
        if (args[0] == null) {
            if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
                return null;
            }
            throw new NullPointerException("On method: " + inlineCache.name + " " + inlineCache.type().dropParameterTypes(0, 1));
        }
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = MethodInvocationSupport.lookupTarget(receiverClass, inlineCache, args);
        if (target == null) {
            InlineCache fallbackCallSite = new InlineCache(inlineCache.callerLookup, "fallback", MethodType.methodType(Object.class, Object.class, Object.class, Object[].class), false, new String[0]);
            Object[] fallbackArgs = new Object[]{args[0], inlineCache.name, Arrays.copyOfRange(args, 1, args.length)};
            target = MethodInvocationSupport.lookupTarget(receiverClass, fallbackCallSite, fallbackArgs);
            if (target != null) {
                return MethodInvocationSupport.fallback(fallbackCallSite, fallbackArgs);
            }
            throw new NoSuchMethodError(receiverClass + "::" + inlineCache.name);
        }
        MethodHandle guard = CLASS_GUARD.bindTo(receiverClass);
        MethodHandle fallback = inlineCache.getTarget();
        MethodHandle root = MethodHandles.guardWithTest(guard, target, fallback);
        if (inlineCache.nullSafeGuarded) {
            root = MethodInvocationSupport.makeNullSafeGuarded(root);
        }
        inlineCache.setTarget(root);
        ++inlineCache.depth;
        return target.invokeWithArguments(args);
    }

    private static MethodHandle makeNullSafeGuarded(MethodHandle root) {
        MethodHandle catchThenNull = MethodHandles.dropArguments(MethodHandles.constant(Object.class, null), 0, new Class[]{NullPointerException.class});
        root = MethodHandles.catchException(root, NullPointerException.class, catchThenNull);
        return root;
    }

    private static boolean shouldReturnNull(InlineCache inlineCache, Object arg) {
        return arg == null && inlineCache.nullSafeGuarded;
    }

    private static Object installVTableDispatch(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.vtable == null) {
            inlineCache.vtable = new WeakHashMap();
        }
        MethodHandle lookup = VTABLE_LOOKUP.bindTo(inlineCache).asCollector(Object[].class, args.length);
        MethodHandle exactInvoker = MethodHandles.exactInvoker(inlineCache.type());
        MethodHandle vtableTarget = MethodHandles.foldArguments(exactInvoker, lookup);
        if (inlineCache.nullSafeGuarded) {
            vtableTarget = MethodInvocationSupport.makeNullSafeGuarded(vtableTarget);
        }
        inlineCache.setTarget(vtableTarget);
        if (MethodInvocationSupport.shouldReturnNull(inlineCache, args[0])) {
            return null;
        }
        return vtableTarget.invokeWithArguments(args);
    }

    private static boolean isCallOnDynamicObject(InlineCache inlineCache, Object arg) {
        return arg instanceof DynamicObject && !DYNAMIC_OBJECT_RESERVED_METHOD_NAMES.contains(inlineCache.name) && (!"toString".equals(inlineCache.name) || ((DynamicObject)arg).hasMethod("toString"));
    }

    private static MethodHandle guardOnOverloaded(MethodHandle target, MethodInvocation invocation, MethodHandle reset) {
        MethodHandle guard;
        Object[] args = invocation.arguments();
        Class[] types2 = new Class[args.length];
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = args[i] == null ? Object.class : args[i].getClass();
        }
        switch (args.length) {
            case 2: {
                guard = MethodHandles.insertArguments(OVERLOADED_GUARD_1, 0, types2[0], types2[1]);
                break;
            }
            case 3: {
                guard = MethodHandles.insertArguments(OVERLOADED_GUARD_2, 0, types2[0], types2[1], types2[2]);
                break;
            }
            case 4: {
                guard = MethodHandles.insertArguments(OVERLOADED_GUARD_3, 0, types2[0], types2[1], types2[2], types2[3]);
                break;
            }
            case 5: {
                guard = MethodHandles.insertArguments(OVERLOADED_GUARD_4, 0, types2[0], types2[1], types2[2], types2[3], types2[4]);
                break;
            }
            default: {
                guard = OVERLOADED_GUARD_GENERIC.bindTo(types2).asCollector(Object[].class, types2.length);
            }
        }
        return MethodHandles.guardWithTest(guard, target, reset);
    }

    private static MethodHandle findTarget(MethodInvocation invocation, InlineCache inlineCache) {
        MethodHandles.Lookup lookup = inlineCache.callerLookup;
        RegularMethodFinder regularMethodFinder = new RegularMethodFinder(invocation, lookup);
        MethodHandle target = regularMethodFinder.find();
        if (target != null) {
            if (regularMethodFinder.isOverloaded()) {
                return MethodInvocationSupport.guardOnOverloaded(target, invocation, inlineCache.resetFallback);
            }
            return target;
        }
        target = new PropertyMethodFinder(invocation, lookup).find();
        if (target != null) {
            return target;
        }
        target = new AugmentationMethodFinder(invocation, lookup).find();
        if (target != null) {
            return target;
        }
        return null;
    }

    static {
        DYNAMIC_OBJECT_RESERVED_METHOD_NAMES = new HashSet<String>(){
            {
                this.add("get");
                this.add("define");
                this.add("undefine");
                this.add("mixin");
                this.add("copy");
                this.add("freeze");
                this.add("properties");
                this.add("invoker");
                this.add("hasMethod");
                this.add("fallback");
                this.add("hasKind");
                this.add("sameKind");
            }
        };
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CLASS_GUARD = lookup.findStatic(MethodInvocationSupport.class, "classGuard", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            FALLBACK = lookup.findStatic(MethodInvocationSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
            RESET_FALLBACK = lookup.findStatic(MethodInvocationSupport.class, "resetFallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
            VTABLE_LOOKUP = lookup.findStatic(MethodInvocationSupport.class, "vtableLookup", MethodType.methodType(MethodHandle.class, InlineCache.class, Object[].class));
            OVERLOADED_GUARD_GENERIC = lookup.findStatic(MethodInvocationSupport.class, "overloadedGuard_generic", MethodType.methodType(Boolean.TYPE, Class[].class, Object[].class));
            OVERLOADED_GUARD_1 = lookup.findStatic(MethodInvocationSupport.class, "overloadedGuard_1", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Object.class, Object.class));
            OVERLOADED_GUARD_2 = lookup.findStatic(MethodInvocationSupport.class, "overloadedGuard_2", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Class.class, Object.class, Object.class, Object.class));
            OVERLOADED_GUARD_3 = lookup.findStatic(MethodInvocationSupport.class, "overloadedGuard_3", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Class.class, Class.class, Object.class, Object.class, Object.class, Object.class));
            OVERLOADED_GUARD_4 = lookup.findStatic(MethodInvocationSupport.class, "overloadedGuard_4", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Class.class, Class.class, Class.class, Object.class, Object.class, Object.class, Object.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static final class InlineCache
    extends MutableCallSite {
        static final int MEGAMORPHIC_THRESHOLD = 5;
        final MethodHandles.Lookup callerLookup;
        final String name;
        final boolean nullSafeGuarded;
        final String[] argumentNames;
        int depth = 0;
        MethodHandle resetFallback;
        WeakHashMap<Class<?>, MethodHandle> vtable;

        InlineCache(MethodHandles.Lookup callerLookup, String name, MethodType type, boolean nullSafeGuarded, String ... argumentNames) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
            this.nullSafeGuarded = nullSafeGuarded;
            this.argumentNames = argumentNames;
        }

        boolean isMegaMorphic() {
            return this.depth > 5;
        }

        public MethodInvocation toMethodInvocation(Object[] args) {
            return new MethodInvocation(this.name, this.type(), args, this.argumentNames);
        }
    }
}

