/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferencesHolder;

public abstract class GoloAssignment
extends GoloStatement
implements ReferencesHolder {
    private boolean declaring = false;
    private ExpressionStatement expressionStatement;

    GoloAssignment() {
    }

    public boolean isDeclaring() {
        return this.declaring;
    }

    public GoloAssignment declaring(boolean isDeclaring) {
        this.declaring = isDeclaring;
        return this;
    }

    public GoloAssignment declaring() {
        return this.declaring(true);
    }

    public ExpressionStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    public GoloAssignment as(Object expr) {
        this.expressionStatement = ExpressionStatement.of(expr);
        this.makeParentOf(this.expressionStatement);
        return this;
    }

    public abstract GoloAssignment to(Object ... var1);

    @Override
    public LocalReference[] getDeclaringReferences() {
        if (this.declaring) {
            return this.getReferences();
        }
        return new LocalReference[0];
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!original.equals(this.getExpressionStatement()) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.as(newElement);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }
}

