/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import java.util.Arrays;
import org.eclipse.golo.cli.command.Metadata;

public final class Warnings {
    private static final boolean NO_PARAMETER_NAMES = Warnings.load("golo.warnings.no-parameter-names", "true");
    private static final boolean UNAVAILABLE_CLASS = Warnings.load("golo.warnings.unavailable-class", "false");

    private Warnings() {
    }

    private static boolean load(String property, String def) {
        return Boolean.valueOf(System.getProperty(property, def));
    }

    public static void noParameterNames(String methodName, String[] argumentNames) {
        if (NO_PARAMETER_NAMES) {
            Messages.warning(Messages.message("no_parameter_names", methodName, Arrays.toString(argumentNames), Metadata.GUIDE_BASE));
        }
    }

    public static void unavailableClass(String className, String callerModule) {
        if (UNAVAILABLE_CLASS && !className.startsWith("java.lang") && !className.startsWith("gololang")) {
            Messages.warning(Messages.message("unavailable_class", className, callerModule, Metadata.GUIDE_BASE));
        }
    }
}

