/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.FunctionReference;
import gololang.Predefined;
import gololang.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.ModuleDocumentation;

public abstract class AbstractProcessor {
    private TemplateEngine templateEngine = new TemplateEngine();
    private HashMap<String, FunctionReference> templateCache = new HashMap();
    private Path targetFolder;
    private Set<ModuleDocumentation> modules = new TreeSet<ModuleDocumentation>();

    public abstract String render(ModuleDocumentation var1) throws Throwable;

    public abstract void process(Map<String, ModuleDocumentation> var1, Path var2) throws Throwable;

    public void setTargetFolder(Path target) {
        this.targetFolder = target.toAbsolutePath();
    }

    public Path getTargetFolder() {
        return this.targetFolder;
    }

    public Set<ModuleDocumentation> modules() {
        return this.modules;
    }

    protected void addModule(ModuleDocumentation module) {
        this.modules.add(module);
    }

    protected String fileExtension() {
        return "";
    }

    protected FunctionReference template(String name, String format) throws IOException {
        String key = name + "-" + format;
        if (this.templateCache.containsKey(key)) {
            return this.templateCache.get(key);
        }
        InputStream in = AbstractProcessor.class.getResourceAsStream("/org/eclipse/golo/doc/" + key);
        if (in == null) {
            throw new IllegalArgumentException("There is no template " + name + " for format: " + format);
        }
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            int nread;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((nread = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, nread);
            }
            FunctionReference compiledTemplate = this.templateEngine.compile(builder.toString());
            this.templateCache.put(key, compiledTemplate);
            FunctionReference functionReference = compiledTemplate;
            return functionReference;
        }
    }

    public Path outputFile(String name) {
        if (this.targetFolder == null) {
            throw new IllegalStateException("no target folder defined");
        }
        return this.targetFolder.resolve(name.replace('.', '/') + (this.fileExtension().isEmpty() ? "" : "." + this.fileExtension()));
    }

    public Path docFile(DocumentationElement doc) {
        DocumentationElement parent;
        for (parent = doc; parent.parent() != parent; parent = parent.parent()) {
        }
        return this.outputFile(parent.name());
    }

    public String linkToFile(DocumentationElement src, String dst) {
        Path doc = this.docFile(src);
        if (doc.getParent() != null) {
            doc = doc.getParent();
        }
        return doc.relativize(this.outputFile(dst)).toString();
    }

    public String linkToFile(String src, String dst) {
        Path out = this.outputFile(src);
        if (out.getParent() != null) {
            out = out.getParent();
        }
        return out.relativize(this.outputFile(dst)).toString();
    }

    protected void renderIndex(String templateName) throws Throwable {
        FunctionReference indexTemplate = this.template(templateName, this.fileExtension());
        String index = (String)indexTemplate.invoke(this);
        Predefined.textToFile(index, this.outputFile(templateName));
    }

    private static String subsection(String line, int level) {
        if (!line.trim().startsWith("#") || line.startsWith("    ")) {
            return line;
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            output.append('#');
        }
        output.append(line.trim());
        return output.toString();
    }

    public static String adaptSections(String documentation, int rootLevel) {
        StringBuilder output = new StringBuilder();
        for (String line : documentation.split("\n")) {
            output.append(AbstractProcessor.subsection(line, rootLevel));
            output.append("\n");
        }
        return output.toString();
    }
}

