/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.Module;
import org.eclipse.golo.runtime.TypeMatching;

public final class Extractors {
    private Extractors() {
        throw new UnsupportedOperationException("don't instantiate");
    }

    public static Stream<Constructor<?>> getConstructors(Class<?> klass) {
        if (klass == null) {
            return Stream.empty();
        }
        return Stream.of(klass.getConstructors());
    }

    public static Stream<Method> getMethods(Class<?> klass) {
        if (klass == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(klass.getDeclaredMethods()), Stream.of(klass.getMethods())).distinct().sorted((m1, m2) -> {
            if (m1.isVarArgs() && !m2.isVarArgs()) {
                return 1;
            }
            if (m2.isVarArgs() && !m1.isVarArgs()) {
                return -1;
            }
            return 0;
        });
    }

    public static Stream<Field> getFields(Class<?> klass) {
        if (klass == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(klass.getDeclaredFields()), Stream.of(klass.getFields())).distinct();
    }

    public static Stream<String> getImportedNames(Class<?> klass) {
        if (klass == null) {
            return Stream.empty();
        }
        return Stream.of(Module.imports(klass));
    }

    public static Stream<Member> getMembers(Class<?> klass) {
        if (klass == null) {
            return Stream.empty();
        }
        return Stream.concat(Extractors.getMethods(klass), Extractors.getFields(klass));
    }

    public static boolean isPublic(Member m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isStatic(Member m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean isConcrete(Member m) {
        return !Modifier.isAbstract(m.getModifiers());
    }

    public static Predicate<Member> isNamed(String name) {
        return m -> m.getName().equals(name);
    }

    public static Predicate<Method> matchFunctionReference(String name, int arity, boolean varargs) {
        return m -> !(!m.getName().equals(name) || !DecoratorsHelper.isMethodDecorated(m) && !TypeMatching.argumentsNumberMatches(m.getParameterCount(), arity, varargs) || arity >= 0 && m.isVarArgs() != varargs);
    }
}

