/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.FunctionReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.golo.doc.AugmentationDocumentation;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.MemberDocumentation;
import org.eclipse.golo.doc.ModuleDocumentation;
import org.eclipse.golo.doc.NamedAugmentationDocumentation;
import org.eclipse.golo.doc.StructDocumentation;
import org.eclipse.golo.doc.UnionDocumentation;

class DocIndex
implements Iterable<DocumentationElement> {
    private SortedSet<DocumentationElement> elements = new TreeSet<DocumentationElement>();

    DocIndex() {
    }

    public void update(ModuleDocumentation moduleDoc) {
        for (DocumentationElement documentationElement : moduleDoc.functions()) {
            this.elements.add(documentationElement);
        }
        for (StructDocumentation structDocumentation : moduleDoc.structs()) {
            this.elements.add(structDocumentation);
            for (MemberDocumentation memberDocumentation : structDocumentation.members()) {
                this.elements.add(memberDocumentation);
            }
        }
        for (UnionDocumentation unionDocumentation : moduleDoc.unions()) {
            this.elements.add(unionDocumentation);
            for (UnionDocumentation.UnionValueDocumentation unionValueDocumentation : unionDocumentation.values()) {
                this.elements.add(unionValueDocumentation);
                for (MemberDocumentation m : unionValueDocumentation.members()) {
                    this.elements.add(m);
                }
            }
        }
        for (NamedAugmentationDocumentation namedAugmentationDocumentation : moduleDoc.namedAugmentations()) {
            this.elements.add(namedAugmentationDocumentation);
            for (DocumentationElement documentationElement : namedAugmentationDocumentation.functions()) {
                this.elements.add(documentationElement);
            }
        }
        for (AugmentationDocumentation augmentationDocumentation : moduleDoc.augmentations()) {
            this.elements.add(augmentationDocumentation);
            for (DocumentationElement documentationElement : augmentationDocumentation.functions()) {
                this.elements.add(documentationElement);
            }
        }
    }

    public Map<String, Set<DocumentationElement>> groupBy(FunctionReference f) throws Throwable {
        TreeMap<String, Set<DocumentationElement>> map = new TreeMap<String, Set<DocumentationElement>>();
        for (DocumentationElement e : this.elements) {
            String k = f.invoke(e).toString();
            if (!map.containsKey(k)) {
                map.put(k, new TreeSet());
            }
            map.get(k).add(e);
        }
        return map;
    }

    @Override
    public Iterator<DocumentationElement> iterator() {
        return this.elements.iterator();
    }
}

