/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.spi.CliCommand;

@Parameters(commandNames={"run"}, resourceBundle="commands", commandDescriptionKey="run")
public class RunCommand
implements CliCommand {
    @Parameter(names={"--module"}, descriptionKey="main_module", required=true)
    String module;
    @Parameter(descriptionKey="arguments")
    List<String> arguments = new LinkedList<String>();
    @Parameter(names={"--classpath"}, variableArity=true, descriptionKey="classpath")
    List<String> classpath = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        try {
            this.classpath.add(".");
            URLClassLoader primaryClassLoader = this.primaryClassLoader(this.classpath);
            Thread.currentThread().setContextClassLoader(primaryClassLoader);
            Class<?> module = Class.forName(this.module, true, primaryClassLoader);
            this.callRun(module, this.arguments.toArray(new String[this.arguments.size()]));
        }
        catch (ClassNotFoundException e) {
            Messages.error(Messages.message("module_not_found", this.module));
        }
        catch (CliCommand.NoMainMethodException e) {
            Messages.error(Messages.message("module_no_main", this.module));
        }
    }
}

