/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.Union;

public final class UnionValue
extends GoloElement {
    private final String name;
    private final Set<String> members = new LinkedHashSet<String>();

    UnionValue(Union union, String name) {
        this.name = name;
        this.setParentNode(union);
    }

    public PackageAndClass getPackageAndClass() {
        return this.getUnion().getPackageAndClass().createInnerClass(this.name);
    }

    public Union getUnion() {
        return (Union)this.getParentNode().get();
    }

    public String getName() {
        return this.name;
    }

    public void addMembers(Collection<String> memberNames) {
        this.members.addAll(memberNames);
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public Set<String> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    protected void setParentNode(GoloElement parent) {
        if (!(parent instanceof Union)) {
            throw new IllegalArgumentException("UnionValue can only be defined in a Union");
        }
        super.setParentNode(parent);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnionValue(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
    }
}

