/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Augmentation;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.FunctionContainer;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ModuleImport;
import org.eclipse.golo.compiler.ir.NamedAugmentation;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class GoloModule
extends GoloElement
implements FunctionContainer {
    private final PackageAndClass packageAndClass;
    private final ReferenceTable globalReferences;
    private final Set<ModuleImport> imports = new LinkedHashSet<ModuleImport>();
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();
    private final Map<PackageAndClass, Augmentation> augmentations = new LinkedHashMap<PackageAndClass, Augmentation>();
    private final Set<NamedAugmentation> namedAugmentations = new LinkedHashSet<NamedAugmentation>();
    private final Set<Struct> structs = new LinkedHashSet<Struct>();
    private final Set<Union> unions = new LinkedHashSet<Union>();
    private final Set<LocalReference> moduleState = new LinkedHashSet<LocalReference>();
    private GoloFunction moduleStateInitializer = null;
    private boolean hasMain = false;
    public static final Set<ModuleImport> DEFAULT_IMPORTS = Collections.unmodifiableSet(new HashSet<ModuleImport>(Arrays.asList(new ModuleImport(PackageAndClass.fromString("gololang.Predefined"), true), new ModuleImport(PackageAndClass.fromString("gololang.StandardAugmentations"), true), new ModuleImport(PackageAndClass.fromString("gololang"), true), new ModuleImport(PackageAndClass.fromString("java.lang"), true))));
    public static final String MODULE_INITIALIZER_FUNCTION = "<clinit>";

    public GoloModule(PackageAndClass packageAndClass) {
        this(packageAndClass, new ReferenceTable());
    }

    public GoloModule(PackageAndClass name, ReferenceTable references) {
        this.packageAndClass = name;
        this.globalReferences = references;
    }

    @Override
    public GoloModule ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public PackageAndClass getPackageAndClass() {
        return this.packageAndClass;
    }

    public Set<ModuleImport> getImports() {
        LinkedHashSet<ModuleImport> imp = new LinkedHashSet<ModuleImport>(this.imports);
        imp.addAll(DEFAULT_IMPORTS);
        return imp;
    }

    public Collection<Augmentation> getAugmentations() {
        return Collections.unmodifiableCollection(this.augmentations.values());
    }

    public Set<NamedAugmentation> getNamedAugmentations() {
        return Collections.unmodifiableSet(this.namedAugmentations);
    }

    public void addImport(ModuleImport moduleImport) {
        this.imports.add(moduleImport);
        this.makeParentOf(moduleImport);
    }

    @Override
    public Set<GoloFunction> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    @Override
    public void addFunctions(Collection<GoloFunction> functions) {
        for (GoloFunction f : functions) {
            this.addFunction(f);
        }
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public boolean hasMain() {
        return this.hasMain;
    }

    @Override
    public void addFunction(GoloFunction function) {
        function.relinkTopLevel(this.globalReferences);
        this.functions.add(function);
        if (function.isMain()) {
            this.hasMain = true;
        }
        this.makeParentOf(function);
    }

    public void addNamedAugmentation(NamedAugmentation augment) {
        this.namedAugmentations.add(augment);
        this.makeParentOf(augment);
    }

    public Augmentation addAugmentation(Augmentation augment) {
        if (augment.hasLocalTarget()) {
            augment.setTargetPackage(this.packageAndClass + ".types");
        }
        if (this.augmentations.containsKey(augment.getTarget())) {
            this.augmentations.get(augment.getTarget()).merge(augment);
        } else {
            this.augmentations.put(augment.getTarget(), augment);
        }
        this.makeParentOf(augment);
        return this.augmentations.get(augment.getTarget());
    }

    public void addStruct(Struct struct) {
        this.structs.add(struct);
        this.makeParentOf(struct);
        struct.setModuleName(this.getPackageAndClass());
    }

    public GoloElement getSubtypeByName(String name) {
        for (Struct s : this.structs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        for (Union u : this.unions) {
            if (!u.getName().equals(name)) continue;
            return u;
        }
        return null;
    }

    public void addUnion(Union union) {
        this.unions.add(union);
        this.makeParentOf(union);
        union.setModuleName(this.getPackageAndClass());
        this.addImport(new ModuleImport(union.getPackageAndClass(), true));
    }

    public void addModuleStateInitializer(AssignmentStatement assignment) {
        this.addLocalState(assignment.getLocalReference());
        if (this.moduleStateInitializer == null) {
            this.moduleStateInitializer = Builders.functionDeclaration().name(MODULE_INITIALIZER_FUNCTION).synthetic().block(Builders.block().ref(this.globalReferences));
            this.functions.add(this.moduleStateInitializer);
        }
        this.moduleStateInitializer.getBlock().addStatement(assignment);
    }

    private void addLocalState(LocalReference reference) {
        this.moduleState.add(reference);
        this.makeParentOf(reference);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitModule(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (ModuleImport moduleImport : this.imports) {
            moduleImport.accept(visitor);
        }
        for (Union union : this.unions) {
            union.accept(visitor);
        }
        for (Struct struct : this.structs) {
            struct.accept(visitor);
        }
        for (Augmentation augment : this.augmentations.values()) {
            augment.accept(visitor);
        }
        for (NamedAugmentation augmentation : this.namedAugmentations) {
            augmentation.accept(visitor);
        }
        for (LocalReference moduleState : this.moduleState) {
            moduleState.accept(visitor);
        }
        for (GoloFunction function : new LinkedList<GoloFunction>(this.functions)) {
            function.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }
}

