/*
 * Decompiled with CFR 0.152.
 */
package gololang.concurrent.async;

import gololang.concurrent.async.Future;
import java.util.HashSet;

public final class Promise {
    private volatile boolean resolved = false;
    private volatile Object value;
    private final Object lock = new Object();
    private final HashSet<Future.Observer> setObservers = new HashSet();
    private final HashSet<Future.Observer> failObservers = new HashSet();

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isFailed() {
        return this.value instanceof Throwable;
    }

    public Object get() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object blockingGet() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.resolved) {
                this.lock.wait();
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise set(Object value) {
        if (this.resolved) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.resolved) {
                this.value = value;
                this.resolved = true;
                this.lock.notifyAll();
            }
        }
        HashSet<Future.Observer> observers = this.isFailed() ? this.failObservers : this.setObservers;
        for (Future.Observer observer : observers) {
            observer.apply(value);
        }
        return this;
    }

    public Promise fail(Throwable throwable) {
        return this.set(throwable);
    }

    public Future future() {
        return new Future(){

            @Override
            public Object get() {
                return Promise.this.get();
            }

            @Override
            public Object blockingGet() throws InterruptedException {
                return Promise.this.blockingGet();
            }

            @Override
            public boolean isResolved() {
                return Promise.this.isResolved();
            }

            @Override
            public boolean isFailed() {
                return Promise.this.isFailed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Future onSet(Future.Observer observer) {
                Object object = Promise.this.lock;
                synchronized (object) {
                    if (Promise.this.resolved && !Promise.this.isFailed()) {
                        observer.apply(Promise.this.value);
                    } else {
                        Promise.this.setObservers.add(observer);
                    }
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Future onFail(Future.Observer observer) {
                Object object = Promise.this.lock;
                synchronized (object) {
                    if (Promise.this.resolved && Promise.this.isFailed()) {
                        observer.apply(Promise.this.value);
                    } else {
                        Promise.this.failObservers.add(observer);
                    }
                }
                return this;
            }
        };
    }

    public String toString() {
        return "Promise{resolved=" + this.resolved + ", value=" + this.value + '}';
    }
}

