/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.FuzzyMap;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.StringKey;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Nullable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<FuzzyMap.IKey, ParameterDescription> m_descriptions;
    private List<Object> m_objects = Lists.newArrayList();
    private boolean m_firstTimeMainParameter = true;
    private Parameterized m_mainParameter = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private ParameterDescription m_mainParameterDescription;
    private Map<Parameterized, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Parameterized, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;
    private IDefaultProvider m_defaultProvider;
    private Map<ProgramName, JCommander> m_commands = Maps.newLinkedHashMap();
    private Map<FuzzyMap.IKey, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String m_parsedCommand;
    private String m_parsedAlias;
    private ProgramName m_programName;
    private Comparator<? super ParameterDescription> m_parameterDescriptionComparator = new Comparator<ParameterDescription>(){

        @Override
        public int compare(ParameterDescription parameterDescription, ParameterDescription parameterDescription2) {
            return parameterDescription.getLongestName().compareTo(parameterDescription2.getLongestName());
        }
    };
    private int m_columnSize = 79;
    private boolean m_helpWasSpecified;
    private List<String> m_unknownArgs = Lists.newArrayList();
    private boolean m_acceptUnknownOptions = false;
    private boolean m_allowParameterOverwriting = false;
    private static Console m_console;
    private boolean expandAtSign = true;
    private static LinkedList<IStringConverterFactory> CONVERTER_FACTORIES;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();
    private int m_verbose = 0;
    private boolean m_caseSensitiveOptions = true;
    private boolean m_allowAbbreviatedOptions = false;

    public JCommander() {
    }

    public JCommander(Object object) {
        this.addObject(object);
        this.createDescriptions();
    }

    public JCommander(Object object, @Nullable ResourceBundle resourceBundle) {
        this.addObject(object);
        this.setDescriptionsBundle(resourceBundle);
    }

    public JCommander(Object object, ResourceBundle resourceBundle, String ... stringArray) {
        this.addObject(object);
        this.setDescriptionsBundle(resourceBundle);
        this.parse(stringArray);
    }

    public JCommander(Object object, String ... stringArray) {
        this.addObject(object);
        this.parse(stringArray);
    }

    public void setExpandAtSign(boolean bl) {
        this.expandAtSign = bl;
    }

    public static Console getConsole() {
        if (m_console == null) {
            try {
                Method method = System.class.getDeclaredMethod("console", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                m_console = new JDK6Console(object);
            }
            catch (Throwable throwable) {
                m_console = new DefaultConsole();
            }
        }
        return m_console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.m_objects.add(t);
            }
        } else if (object.getClass().isArray()) {
            for (Object object2 : (Object[])object) {
                this.m_objects.add(object2);
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    public void parse(String ... stringArray) {
        this.parse(true, stringArray);
    }

    public void parseWithoutValidation(String ... stringArray) {
        this.parse(false, stringArray);
    }

    private void parse(boolean bl, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder("Parsing \"");
        stringBuilder.append((CharSequence)this.join(stringArray).append("\"\n  with:").append((CharSequence)this.join(this.m_objects.toArray())));
        this.p(stringBuilder.toString());
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(stringArray), bl);
        if (bl) {
            this.validateOptions();
        }
    }

    private StringBuilder join(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder;
    }

    private void initializeDefaultValues() {
        if (this.m_defaultProvider != null) {
            for (ParameterDescription object : this.m_descriptions.values()) {
                this.initializeDefaultValue(object);
            }
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.m_helpWasSpecified) {
            return;
        }
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ParameterDescription parameterDescription : this.m_requiredFields.values()) {
                stringBuilder.append(parameterDescription.getNames()).append(" ");
            }
            throw new ParameterException("The following " + JCommander.pluralize(this.m_requiredFields.size(), "option is required: ", "options are required: ") + stringBuilder);
        }
        if (this.m_mainParameterDescription != null && this.m_mainParameterDescription.getParameter().required() && !this.m_mainParameterDescription.isAssigned()) {
            throw new ParameterException("Main parameters are required (\"" + this.m_mainParameterDescription.getDescription() + "\")");
        }
    }

    private static String pluralize(int n, String string, String string2) {
        return n == 1 ? string : string2;
    }

    private String[] expandArgs(String[] stringArray) {
        Object object;
        List list = Lists.newArrayList();
        for (String stringArray2 : stringArray) {
            if (stringArray2.startsWith("@") && this.expandAtSign) {
                object = stringArray2.substring(1);
                list.addAll(JCommander.readFile((String)object));
                continue;
            }
            object = this.expandDynamicArg(stringArray2);
            list.addAll(object);
        }
        List list2 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String[] stringArray2 = list.toArray(new String[0]);
            if (this.isOption(stringArray2, string)) {
                object = this.getSeparatorFor(stringArray2, string);
                if (!" ".equals(object)) {
                    String[] stringArray3;
                    for (String string2 : stringArray3 = string.split("[" + (String)object + "]", 2)) {
                        list2.add(string2);
                    }
                    continue;
                }
                list2.add(string);
                continue;
            }
            list2.add(string);
        }
        return list2.toArray(new String[list2.size()]);
    }

    private List<String> expandDynamicArg(String string) {
        for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
            if (!parameterDescription.isDynamicParameter()) continue;
            for (String string2 : parameterDescription.getParameter().names()) {
                if (!string.startsWith(string2) || string.equals(string2)) continue;
                return Arrays.asList(string2, string.substring(string2.length()));
            }
        }
        return Arrays.asList(string);
    }

    private boolean isOption(String[] stringArray, String string) {
        String string2 = this.getOptionPrefixes(stringArray, string);
        return string.length() > 0 && string2.indexOf(string.charAt(0)) >= 0;
    }

    private ParameterDescription getPrefixDescriptionFor(String string) {
        for (Map.Entry<FuzzyMap.IKey, ParameterDescription> entry : this.m_descriptions.entrySet()) {
            if (!string.startsWith(entry.getKey().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String[] stringArray, String string) {
        ParameterDescription parameterDescription = this.getPrefixDescriptionFor(string);
        if (parameterDescription != null) {
            return parameterDescription;
        }
        for (String string2 : stringArray) {
            ParameterDescription parameterDescription2 = this.getPrefixDescriptionFor(string);
            if (parameterDescription2 != null) {
                parameterDescription = parameterDescription2;
            }
            if (!string2.equals(string)) continue;
            return parameterDescription;
        }
        throw new ParameterException("Unknown parameter: " + string);
    }

    private String getSeparatorFor(String[] stringArray, String string) {
        Parameters parameters;
        ParameterDescription parameterDescription = this.getDescriptionFor(stringArray, string);
        if (parameterDescription != null && (parameters = parameterDescription.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return parameters.separators();
        }
        return " ";
    }

    private String getOptionPrefixes(String[] stringArray, String string) {
        Object object;
        ParameterDescription parameterDescription = this.getDescriptionFor(stringArray, string);
        if (parameterDescription != null && (object = parameterDescription.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return object.optionPrefixes();
        }
        object = "-";
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : this.m_objects) {
            Parameters parameters = object2.getClass().getAnnotation(Parameters.class);
            if (parameters == null || "-".equals(parameters.optionPrefixes())) continue;
            stringBuilder.append(parameters.optionPrefixes());
        }
        if (!Strings.isStringEmpty(stringBuilder.toString())) {
            object = stringBuilder.toString();
        }
        return object;
    }

    private static List<String> readFile(String string) {
        List<String> list = Lists.newArrayList();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.trim().startsWith("#")) continue;
                list.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ParameterException("Could not read file " + string + ": " + iOException);
        }
        return list;
    }

    private static String trim(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> clazz = object.getClass();
        List<Parameterized> list = Parameterized.parseArg(object);
        for (Parameterized parameterized : list) {
            Object object2;
            WrappedParameter wrappedParameter = parameterized.getWrappedParameter();
            if (wrappedParameter != null && wrappedParameter.getParameter() != null) {
                object2 = wrappedParameter.getParameter();
                Object object3 = object2;
                if (object3.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.m_mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameter + " and " + parameterized);
                    }
                    this.m_mainParameter = parameterized;
                    this.m_mainParameterObject = object;
                    this.m_mainParameterAnnotation = object3;
                    this.m_mainParameterDescription = new ParameterDescription(object, (Parameter)object3, parameterized, this.m_bundle, this);
                    continue;
                }
                ParameterDescription parameterDescription = new ParameterDescription(object, (Parameter)object3, parameterized, this.m_bundle, this);
                for (String string : object3.names()) {
                    if (this.m_descriptions.containsKey(new StringKey(string))) {
                        throw new ParameterException("Found the option " + string + " multiple times");
                    }
                    this.p("Adding description for " + string);
                    this.m_fields.put(parameterized, parameterDescription);
                    this.m_descriptions.put(new StringKey(string), parameterDescription);
                    if (!object3.required()) continue;
                    this.m_requiredFields.put(parameterized, parameterDescription);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                object2 = parameterized.get(object);
                if (object2 == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(object2);
                continue;
            }
            if (wrappedParameter == null || wrappedParameter.getDynamicParameter() == null) continue;
            object2 = wrappedParameter.getDynamicParameter();
            for (String string : object2.names()) {
                if (this.m_descriptions.containsKey(string)) {
                    throw new ParameterException("Found the option " + string + " multiple times");
                }
                this.p("Adding description for " + string);
                ParameterDescription parameterDescription = new ParameterDescription(object, (DynamicParameter)object2, parameterized, this.m_bundle, this);
                this.m_fields.put(parameterized, parameterDescription);
                this.m_descriptions.put(new StringKey(string), parameterDescription);
                if (!object2.required()) continue;
                this.m_requiredFields.put(parameterized, parameterDescription);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription parameterDescription) {
        for (String string : parameterDescription.getParameter().names()) {
            String string2 = this.m_defaultProvider.getDefaultValueFor(string);
            if (string2 == null) continue;
            this.p("Initializing " + string + " with default value:" + string2);
            parameterDescription.addValue(string2, true);
            this.m_requiredFields.remove(parameterDescription.getParameterized());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseValues(String[] stringArray, boolean bl) {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length && !bl2; i += n) {
            Object object;
            Object object2;
            String string;
            String string2 = stringArray[i];
            stringArray[i] = string = JCommander.trim(string2);
            this.p("Parsing arg: " + string);
            JCommander jCommander = this.findCommandByAlias(string2);
            n = 1;
            if (!bl3 && !"--".equals(string) && this.isOption(stringArray, string) && jCommander == null) {
                object2 = this.findParameterDescription(string);
                if (object2 != null) {
                    if (((ParameterDescription)object2).getParameter().password()) {
                        object = this.readPassword(((ParameterDescription)object2).getDescription(), ((ParameterDescription)object2).getParameter().echoInput());
                        ((ParameterDescription)object2).addValue(new String((char[])object));
                        this.m_requiredFields.remove(((ParameterDescription)object2).getParameterized());
                        continue;
                    }
                    if (((ParameterDescription)object2).getParameter().variableArity()) {
                        n = this.processVariableArity(stringArray, i, (ParameterDescription)object2);
                        continue;
                    }
                    object = ((ParameterDescription)object2).getParameterized().getType();
                    if ((object == Boolean.TYPE || object == Boolean.class) && ((ParameterDescription)object2).getParameter().arity() == -1) {
                        ((ParameterDescription)object2).addValue("true");
                        this.m_requiredFields.remove(((ParameterDescription)object2).getParameterized());
                    } else {
                        n = this.processFixedArity(stringArray, i, (ParameterDescription)object2, (Class<?>)object);
                    }
                    if (!((ParameterDescription)object2).isHelp()) continue;
                    this.m_helpWasSpecified = true;
                    continue;
                }
                if (this.m_acceptUnknownOptions) {
                    this.m_unknownArgs.add(string2);
                    ++i;
                    while (i < stringArray.length && !this.isOption(stringArray, stringArray[i])) {
                        this.m_unknownArgs.add(stringArray[i++]);
                    }
                    n = 0;
                    continue;
                }
                throw new ParameterException("Unknown option: " + (String)string2);
            }
            if (Strings.isStringEmpty(string2)) continue;
            if ("--".equals(string2)) {
                bl3 = true;
                String string3 = JCommander.trim(stringArray[++i]);
            }
            if (this.m_commands.isEmpty()) {
                ParameterizedType parameterizedType;
                Type type;
                void object22;
                object2 = this.getMainParameter(string2);
                object = object22;
                Object object3 = object;
                if (this.m_mainParameter.getGenericType() instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)this.m_mainParameter.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    object3 = this.convertValue(this.m_mainParameter, (Class)type, (String)object);
                }
                ParameterDescription.validateParameter(this.m_mainParameterDescription, this.m_mainParameterAnnotation.validateWith(), "Default", (String)object);
                this.m_mainParameterDescription.setAssigned(true);
                object2.add(object3);
                continue;
            }
            if (jCommander == null && bl) {
                throw new MissingCommandException("Expected a command, got " + (String)string2);
            }
            if (jCommander == null) continue;
            this.m_parsedCommand = jCommander.m_programName.m_name;
            this.m_parsedAlias = string2;
            jCommander.parse(this.subArray(stringArray, i + 1));
            bl2 = true;
        }
        for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.m_fields.get(parameterDescription.getParameterized()).setAssigned(true);
        }
    }

    private int processVariableArity(String[] stringArray, int n, ParameterDescription parameterDescription) {
        int n2;
        Object object = parameterDescription.getObject();
        IVariableArity iVariableArity = !(object instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)object;
        List list = Lists.newArrayList();
        for (n2 = n + 1; n2 < stringArray.length; ++n2) {
            list.add(stringArray[n2]);
        }
        n2 = iVariableArity.processVariableArity(parameterDescription.getParameter().names()[0], list.toArray(new String[0]));
        int n3 = this.processFixedArity(stringArray, n, parameterDescription, List.class, n2);
        return n3;
    }

    private int processFixedArity(String[] stringArray, int n, ParameterDescription parameterDescription, Class<?> clazz) {
        int n2 = parameterDescription.getParameter().arity();
        int n3 = n2 != -1 ? n2 : 1;
        return this.processFixedArity(stringArray, n, parameterDescription, clazz, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] stringArray, int n, ParameterDescription parameterDescription, Class<?> clazz, int n2) {
        int n3 = n;
        String string = stringArray[n3];
        if (n2 == 0 && (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz))) {
            parameterDescription.addValue("true");
            this.m_requiredFields.remove(parameterDescription.getParameterized());
            return n2 + 1;
        } else {
            int n4;
            if (n3 >= stringArray.length - 1) throw new ParameterException("Expected a value after parameter " + string);
            int n5 = n4 = "--".equals(stringArray[n3 + 1]) ? 1 : 0;
            if (n3 + n2 >= stringArray.length) throw new ParameterException("Expected " + n2 + " values after " + string);
            for (int i = 1; i <= n2; ++i) {
                parameterDescription.addValue(JCommander.trim(stringArray[n3 + i + n4]));
                this.m_requiredFields.remove(parameterDescription.getParameterized());
            }
            n3 += n2 + n4;
        }
        return n2 + 1;
    }

    private char[] readPassword(String string, boolean bl) {
        JCommander.getConsole().print(string + ": ");
        return JCommander.getConsole().readPassword(bl);
    }

    private String[] subArray(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    private List<?> getMainParameter(String string) {
        if (this.m_mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + string + "' but no main parameter was defined");
        }
        List list = (List)this.m_mainParameter.get(this.m_mainParameterObject);
        if (list == null) {
            list = Lists.newArrayList();
            if (!List.class.isAssignableFrom(this.m_mainParameter.getType())) {
                throw new ParameterException("Main parameter field " + this.m_mainParameter + " needs to be of type List, not " + this.m_mainParameter.getType());
            }
            this.m_mainParameter.set(this.m_mainParameterObject, list);
        }
        if (this.m_firstTimeMainParameter) {
            list.clear();
            this.m_firstTimeMainParameter = false;
        }
        return list;
    }

    public String getMainParameterDescription() {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        return this.m_mainParameterAnnotation != null ? this.m_mainParameterAnnotation.description() : null;
    }

    public void setProgramName(String string) {
        this.setProgramName(string, new String[0]);
    }

    public void setProgramName(String string, String ... stringArray) {
        this.m_programName = new ProgramName(string, Arrays.asList(stringArray));
    }

    public void usage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(string, stringBuilder);
        JCommander.getConsole().println(stringBuilder.toString());
    }

    public void usage(String string, StringBuilder stringBuilder) {
        this.usage(string, stringBuilder, "");
    }

    public void usage(String string, StringBuilder stringBuilder, String string2) {
        String string3 = this.getCommandDescription(string);
        JCommander jCommander = this.findCommandByAlias(string);
        if (string3 != null) {
            stringBuilder.append(string2).append(string3);
            stringBuilder.append("\n");
        }
        jCommander.usage(stringBuilder, string2);
    }

    public String getCommandDescription(String string) {
        JCommander jCommander = this.findCommandByAlias(string);
        if (jCommander == null) {
            throw new ParameterException("Asking description for unknown command: " + string);
        }
        Object object = jCommander.getObjects().get(0);
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (parameters != null) {
            string2 = parameters.commandDescription();
            String string3 = parameters.resourceBundle();
            resourceBundle = !"".equals(string3) ? ResourceBundle.getBundle(string3, Locale.getDefault()) : this.m_bundle;
            if (resourceBundle != null) {
                string2 = this.getI18nString(resourceBundle, parameters.commandDescriptionKey(), parameters.commandDescription());
            }
        }
        return string2;
    }

    private String getI18nString(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = resourceBundle != null ? resourceBundle.getString(string) : null;
        return string3 != null ? string3 : string2;
    }

    public void usage() {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(stringBuilder);
        JCommander.getConsole().println(stringBuilder.toString());
    }

    public void usage(StringBuilder stringBuilder) {
        this.usage(stringBuilder, "");
    }

    public void usage(StringBuilder stringBuilder, String string) {
        Object object;
        Object object2;
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        boolean bl = !this.m_commands.isEmpty();
        int n = 6;
        int n2 = string.length() + n;
        String string2 = this.m_programName != null ? this.m_programName.getDisplayName() : "<main class>";
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(string).append("Usage: ").append(string2).append(" [options]");
        if (bl) {
            stringBuilder2.append(string).append(" [command] [command options]");
        }
        if (this.m_mainParameterDescription != null) {
            stringBuilder2.append(" ").append(this.m_mainParameterDescription.getDescription());
        }
        this.wrapDescription(stringBuilder, n2, stringBuilder2.toString());
        stringBuilder.append("\n");
        int n3 = 0;
        List<Object> list = Lists.newArrayList();
        for (ParameterDescription object3 : this.m_fields.values()) {
            if (object3.getParameter().hidden()) continue;
            list.add(object3);
            int n4 = object3.getNames().length() + 2;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        Collections.sort(list, this.getParameterDescriptionComparator());
        if (list.size() > 0) {
            stringBuilder.append(string).append("  Options:\n");
        }
        for (ParameterDescription parameterDescription : list) {
            WrappedParameter wrappedParameter = parameterDescription.getParameter();
            stringBuilder.append(string).append("  " + (wrappedParameter.required() ? "* " : "  ") + parameterDescription.getNames() + "\n");
            this.wrapDescription(stringBuilder, n2, this.s(n2) + parameterDescription.getDescription());
            object2 = parameterDescription.getDefault();
            if (parameterDescription.isDynamicParameter()) {
                stringBuilder.append("\n" + this.s(n2)).append("Syntax: " + wrappedParameter.names()[0] + "key" + wrappedParameter.getAssignment() + "value");
            }
            if (object2 != null) {
                object = Strings.isStringEmpty(object2.toString()) ? "<empty string>" : object2.toString();
                stringBuilder.append("\n" + this.s(n2)).append("Default: " + (String)(wrappedParameter.password() ? "********" : object));
            }
            if (((Class)(object = parameterDescription.getParameterized().getType())).isEnum()) {
                stringBuilder.append("\n" + this.s(n2)).append("Possible Values: " + EnumSet.allOf(object));
            }
            stringBuilder.append("\n");
        }
        if (bl) {
            stringBuilder.append("  Commands:\n");
            for (Map.Entry entry : this.m_commands.entrySet()) {
                Object object3 = ((JCommander)entry.getValue()).getObjects().get(0);
                object2 = object3.getClass().getAnnotation(Parameters.class);
                if (object2 != null && object2.hidden()) continue;
                object = (ProgramName)entry.getKey();
                String string3 = ((ProgramName)object).getDisplayName();
                String string4 = this.getCommandDescription(((ProgramName)object).getName());
                this.wrapDescription(stringBuilder, n2 + n, string + "    " + string3 + "      " + string4);
                stringBuilder.append("\n");
                JCommander jCommander = this.findCommandByAlias(((ProgramName)object).getName());
                jCommander.usage(stringBuilder, "      ");
                stringBuilder.append("\n");
            }
        }
    }

    private Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.m_parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> comparator) {
        this.m_parameterDescriptionComparator = comparator;
    }

    public void setColumnSize(int n) {
        this.m_columnSize = n;
    }

    public int getColumnSize() {
        return this.m_columnSize;
    }

    private void wrapDescription(StringBuilder stringBuilder, int n, String string) {
        int n2 = this.getColumnSize();
        String[] stringArray = string.split(" ");
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() > n2 || n3 + 1 + string2.length() <= n2) {
                stringBuilder.append(string2).append(" ");
                n3 += string2.length() + 1;
                continue;
            }
            stringBuilder.append("\n").append(this.s(n)).append(string2).append(" ");
            n3 = n + 1 + string2.length();
        }
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    public ParameterDescription getMainParameter() {
        return this.m_mainParameterDescription;
    }

    private void p(String string) {
        if (this.m_verbose > 0 || System.getProperty(DEBUG_PROPERTY) != null) {
            JCommander.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider iDefaultProvider) {
        this.m_defaultProvider = iDefaultProvider;
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            entry.getValue().setDefaultProvider(iDefaultProvider);
        }
    }

    public void addConverterFactory(IStringConverterFactory iStringConverterFactory) {
        CONVERTER_FACTORIES.addFirst(iStringConverterFactory);
    }

    public <T> Class<? extends IStringConverter<T>> findConverter(Class<T> clazz) {
        for (IStringConverterFactory iStringConverterFactory : CONVERTER_FACTORIES) {
            Class<IStringConverter<T>> clazz2 = iStringConverterFactory.getConverter(clazz);
            if (clazz2 == null) continue;
            return clazz2;
        }
        return null;
    }

    public Object convertValue(ParameterDescription parameterDescription, String string) {
        return this.convertValue(parameterDescription.getParameterized(), parameterDescription.getParameterized().getType(), string);
    }

    public Object convertValue(Parameterized parameterized, Class clazz, String string) {
        Object object;
        block20: {
            Object object2;
            boolean bl;
            Parameter parameter = parameterized.getParameter();
            if (parameter == null) {
                return string;
            }
            Class clazz2 = parameter.converter();
            boolean bl2 = bl = parameter.listConverter() != NoConverter.class;
            if (clazz2 == null || clazz2 == NoConverter.class) {
                clazz2 = this.findConverter(clazz);
            }
            if (clazz2 == null && clazz.isEnum()) {
                clazz2 = clazz;
            }
            if (clazz2 == null) {
                object2 = parameterized.findFieldGenericType();
                Class<Object> clazz3 = clazz2 = object2 != null ? this.findConverter((Class)object2) : StringConverter.class;
                if (clazz2 == null && Enum.class.isAssignableFrom((Class)object2)) {
                    clazz2 = (Class)object2;
                }
            }
            object = null;
            try {
                String string2;
                String[] stringArray = parameter.names();
                String string3 = string2 = stringArray.length > 0 ? stringArray[0] : "[Main class]";
                if (clazz2 != null && clazz2.isEnum()) {
                    try {
                        object = Enum.valueOf(clazz2, string);
                        break block20;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        try {
                            object = Enum.valueOf(clazz2, string.toUpperCase());
                            break block20;
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {
                            throw new ParameterException("Invalid value for " + string2 + " parameter. Allowed values:" + EnumSet.allOf(clazz2));
                        }
                    }
                    catch (Exception exception) {
                        throw new ParameterException("Invalid value for " + string2 + " parameter. Allowed values:" + EnumSet.allOf(clazz2));
                    }
                }
                object2 = this.instantiateConverter(string2, clazz2);
                if (clazz.isAssignableFrom(List.class) && parameterized.getGenericType() instanceof ParameterizedType) {
                    if (bl) {
                        IStringConverter<?> iStringConverter = this.instantiateConverter(string2, parameter.listConverter());
                        object = iStringConverter.convert(string);
                    } else {
                        object = this.convertToList(string, (IStringConverter<?>)object2, parameter.splitter());
                    }
                } else {
                    object = object2.convert(string);
                }
            }
            catch (InstantiationException instantiationException) {
                throw new ParameterException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParameterException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ParameterException(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ParameterException(noSuchMethodException);
            }
        }
        return object;
    }

    private Object convertToList(String string, IStringConverter<?> iStringConverter, Class<? extends IParameterSplitter> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Constructor<? extends IParameterSplitter> constructor = clazz.getConstructor(new Class[0]);
        constructor.setAccessible(true);
        IParameterSplitter iParameterSplitter = constructor.newInstance(new Object[0]);
        List list = Lists.newArrayList();
        for (String string2 : iParameterSplitter.split(string)) {
            list.add(iStringConverter.convert(string2));
        }
        return list;
    }

    private IStringConverter<?> instantiateConverter(String string, Class<? extends IStringConverter<?>> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray;
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        for (Constructor<?> constructor3 : constructorArray = clazz.getDeclaredConstructors()) {
            constructor3.setAccessible(true);
            Class<?>[] classArray = constructor3.getParameterTypes();
            if (classArray.length == 1 && classArray[0].equals(String.class)) {
                constructor2 = constructor3;
                continue;
            }
            if (classArray.length != 0) continue;
            constructor = constructor3;
        }
        Constructor<?>[] constructorArray2 = constructor2 != null ? (IStringConverter)constructor2.newInstance(string) : (constructor != null ? (IStringConverter)constructor.newInstance(new Object[0]) : null);
        return constructorArray2;
    }

    public void addCommand(String string, Object object) {
        this.addCommand(string, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        if (parameters != null && parameters.commandNames().length > 0) {
            for (String string : parameters.commandNames()) {
                this.addCommand(string, object);
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String string, Object object, String ... stringArray) {
        JCommander jCommander = new JCommander(object);
        jCommander.setProgramName(string, stringArray);
        jCommander.setDefaultProvider(this.m_defaultProvider);
        jCommander.setAcceptUnknownOptions(this.m_acceptUnknownOptions);
        ProgramName programName = jCommander.m_programName;
        this.m_commands.put(programName, jCommander);
        this.aliasMap.put(new StringKey(string), programName);
        for (String string2 : stringArray) {
            StringKey stringKey = new StringKey(string2);
            if (((Object)stringKey).equals(string)) continue;
            ProgramName programName2 = this.aliasMap.get(stringKey);
            if (programName2 != null && !programName2.equals(programName)) {
                throw new ParameterException("Cannot set alias " + stringKey + " for " + string + " command because it has already been defined for " + programName2.m_name + " command");
            }
            this.aliasMap.put(stringKey, programName);
        }
    }

    public Map<String, JCommander> getCommands() {
        Map<String, JCommander> map = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.m_commands.entrySet()) {
            map.put(entry.getKey().m_name, entry.getValue());
        }
        return map;
    }

    public String getParsedCommand() {
        return this.m_parsedCommand;
    }

    public String getParsedAlias() {
        return this.m_parsedAlias;
    }

    private String s(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public List<Object> getObjects() {
        return this.m_objects;
    }

    private ParameterDescription findParameterDescription(String string) {
        return FuzzyMap.findInMap(this.m_descriptions, new StringKey(string), this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private JCommander findCommand(ProgramName programName) {
        return FuzzyMap.findInMap(this.m_commands, programName, this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private ProgramName findProgramName(String string) {
        return FuzzyMap.findInMap(this.aliasMap, new StringKey(string), this.m_caseSensitiveOptions, this.m_allowAbbreviatedOptions);
    }

    private JCommander findCommandByAlias(String string) {
        ProgramName programName = this.findProgramName(string);
        if (programName == null) {
            return null;
        }
        JCommander jCommander = this.findCommand(programName);
        if (jCommander == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jCommander;
    }

    public void setVerbose(int n) {
        this.m_verbose = n;
    }

    public void setCaseSensitiveOptions(boolean bl) {
        this.m_caseSensitiveOptions = bl;
    }

    public void setAllowAbbreviatedOptions(boolean bl) {
        this.m_allowAbbreviatedOptions = bl;
    }

    public void setAcceptUnknownOptions(boolean bl) {
        this.m_acceptUnknownOptions = bl;
    }

    public List<String> getUnknownOptions() {
        return this.m_unknownArgs;
    }

    public void setAllowParameterOverwriting(boolean bl) {
        this.m_allowParameterOverwriting = bl;
    }

    public boolean isParameterOverwritingAllowed() {
        return this.m_allowParameterOverwriting;
    }

    static {
        CONVERTER_FACTORIES = Lists.newLinkedList();
        CONVERTER_FACTORIES.addFirst(new DefaultConverterFactory());
    }

    private static final class ProgramName
    implements FuzzyMap.IKey {
        private final String m_name;
        private final List<String> m_aliases;

        ProgramName(String string, List<String> list) {
            this.m_name = string;
            this.m_aliases = list;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        private String getDisplayName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.m_name);
            if (!this.m_aliases.isEmpty()) {
                stringBuilder.append("(");
                Iterator<String> iterator = this.m_aliases.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProgramName programName = (ProgramName)object;
            return !(this.m_name == null ? programName.m_name != null : !this.m_name.equals(programName.m_name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        @Override
        public int processVariableArity(String string, String[] stringArray) {
            int n;
            for (n = 0; n < stringArray.length && !JCommander.this.isOption(stringArray, stringArray[n]); ++n) {
            }
            return n;
        }
    }
}

