/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.eclipse.golo.runtime.Module;

public final class ClassReferenceSupport {
    private ClassReferenceSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) throws ClassNotFoundException {
        Class<?> callerClass;
        ClassLoader classLoader;
        String className = name.replaceAll("#", "\\.");
        Class<?> classRef = ClassReferenceSupport.tryLoading(className, classLoader = (callerClass = caller.lookupClass()).getClassLoader());
        if (classRef == null) {
            String importClassName;
            String[] stringArray = Module.imports(callerClass);
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (classRef = ClassReferenceSupport.tryLoading((importClassName = stringArray[i]) + "." + className, classLoader)) != null || importClassName.endsWith(className) && (classRef = ClassReferenceSupport.tryLoading(importClassName, classLoader)) != null); ++i) {
            }
        }
        if (classRef != null) {
            return new ConstantCallSite(MethodHandles.constant(Class.class, classRef));
        }
        throw new ClassNotFoundException("Dynamic resolution failed for name: " + name);
    }

    private static Class<?> tryLoading(String name, ClassLoader classLoader) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

