/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.golo.doc.DocumentationElement;

class StructDocumentation
implements Comparable<StructDocumentation>,
DocumentationElement {
    private String name;
    private String documentation;
    private int line;
    private Set<String> members = new LinkedHashSet<String>();

    StructDocumentation() {
    }

    @Override
    public String name() {
        return this.name;
    }

    public StructDocumentation name(String n) {
        this.name = n;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "\n";
    }

    public StructDocumentation documentation(String doc) {
        this.documentation = doc;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public StructDocumentation line(int l) {
        this.line = l;
        return this;
    }

    public Set<String> members() {
        return Collections.unmodifiableSet(this.members);
    }

    public StructDocumentation members(Collection<String> m) {
        this.members.addAll(m);
        return this;
    }

    @Override
    public int compareTo(StructDocumentation o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.name.compareTo(o.name());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructDocumentation)) {
            return false;
        }
        StructDocumentation that = (StructDocumentation)o;
        return this.name.equals(that.name) && this.members.equals(that.members);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.members);
    }
}

