/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.Decorator;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.ReturnStatement;
import org.eclipse.golo.compiler.ir.SymbolGenerator;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class GoloFunction
extends ExpressionStatement
implements org.eclipse.golo.compiler.ir.Scope {
    private static final SymbolGenerator SYMBOLS = new SymbolGenerator("function");
    private String name;
    private boolean isLocal = false;
    private Scope scope = Scope.MODULE;
    private final List<String> parameterNames = new LinkedList<String>();
    private final List<String> syntheticParameterNames = new LinkedList<String>();
    private boolean varargs = false;
    private Block block;
    private boolean synthetic = false;
    private boolean decorator = false;
    private String syntheticSelfName = null;
    private String decoratorRef = null;
    private final LinkedList<Decorator> decorators = new LinkedList();

    GoloFunction() {
        this.block = Builders.block();
        this.makeParentOf(this.block);
    }

    @Override
    public GoloFunction ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public GoloFunction name(String n) {
        this.name = n;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMain() {
        return "main".equals(this.name) && this.getArity() == 1;
    }

    public boolean isModuleInit() {
        return "<clinit>".equals(this.name);
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public GoloFunction synthetic() {
        this.synthetic = true;
        return this;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public GoloFunction decorator() {
        return this.decorator(true);
    }

    public GoloFunction decorator(boolean d) {
        this.decorator = d;
        return this;
    }

    public boolean isDecorator() {
        return this.decorator;
    }

    public GoloFunction local() {
        return this.local(true);
    }

    public GoloFunction local(boolean isLocal) {
        this.isLocal = isLocal;
        return this;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public GoloFunction inScope(Scope s) {
        this.scope = s;
        return this;
    }

    public GoloFunction inAugment() {
        return this.inAugment(true);
    }

    public GoloFunction inAugment(boolean isInAugment) {
        if (isInAugment) {
            this.scope = Scope.AUGMENT;
        }
        return this;
    }

    public boolean isInAugment() {
        return Scope.AUGMENT.equals((Object)this.scope);
    }

    public GoloFunction asClosure() {
        this.scope = Scope.CLOSURE;
        return this;
    }

    public GoloFunction block(Object ... statements) {
        return this.block(Builders.block(statements));
    }

    public GoloFunction block(Block block) {
        this.block = Objects.requireNonNull(block);
        for (String param : this.parameterNames) {
            this.addParameterToBlockReferences(param);
        }
        this.makeParentOf(this.block);
        return this;
    }

    public Block getBlock() {
        return this.block;
    }

    public GoloFunction returns(Object expression) {
        this.block.add(Builders.returns(expression));
        return this;
    }

    public void insertMissingReturnStatement() {
        if (!this.block.hasReturn() && !this.isModuleInit()) {
            ReturnStatement missingReturnStatement = Builders.returns(Builders.constant(null)).synthetic();
            if (this.isMain()) {
                missingReturnStatement.returningVoid();
            }
            this.block.addStatement(missingReturnStatement);
        }
    }

    public GoloFunction varargs(boolean isVarargs) {
        this.varargs = isVarargs;
        return this;
    }

    public GoloFunction varargs() {
        return this.varargs(true);
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public int getArity() {
        return this.parameterNames.size() + this.syntheticParameterNames.size();
    }

    public GoloFunction withParameters(String ... names) {
        return this.withParameters(Arrays.asList(names));
    }

    public GoloFunction withParameters(Collection<String> names) {
        for (String name : names) {
            this.addParameterToBlockReferences(name);
            this.parameterNames.add(name);
        }
        return this;
    }

    private void addParameterToBlockReferences(String name) {
        this.block.getReferenceTable().add(Builders.localRef(name));
    }

    public int getSyntheticParameterCount() {
        return this.syntheticParameterNames.size();
    }

    public List<String> getParameterNames() {
        LinkedList<String> list = new LinkedList<String>(this.syntheticParameterNames);
        list.addAll(this.parameterNames);
        return Collections.unmodifiableList(list);
    }

    public List<String> getSyntheticParameterNames() {
        return Collections.unmodifiableList(this.syntheticParameterNames);
    }

    public void addSyntheticParameters(Set<String> names) {
        HashSet<String> existing = new HashSet<String>(this.getParameterNames());
        for (String name : names) {
            LocalReference ref;
            if (existing.contains(name) || name.equals(this.syntheticSelfName) || (ref = this.block.getReferenceTable().get(name)) != null && ref.isModuleState()) continue;
            this.syntheticParameterNames.add(name);
        }
    }

    public String getSyntheticSelfName() {
        return this.syntheticSelfName;
    }

    public void setSyntheticSelfName(String name) {
        if (this.syntheticParameterNames.contains(name)) {
            this.syntheticParameterNames.remove(name);
            this.syntheticSelfName = name;
        }
    }

    public void captureClosedReference() {
        if (this.synthetic && this.syntheticSelfName != null) {
            LocalReference self = this.block.getReferenceTable().get(this.syntheticSelfName);
            ClosureReference closureReference = this.asClosureReference();
            closureReference.updateCapturedReferenceNames();
            this.block.prependStatement(Builders.assign(closureReference).to(self));
        }
    }

    public GoloFunction decoratedWith(Object ... decorators) {
        for (Object deco : decorators) {
            if (!(deco instanceof Decorator)) {
                throw GoloFunction.cantConvert("Decorator", deco);
            }
            this.addDecorator((Decorator)deco);
        }
        return this;
    }

    public boolean isDecorated() {
        return !this.decorators.isEmpty();
    }

    public String getDecoratorRef() {
        return this.decoratorRef;
    }

    public void addDecorator(Decorator decorator) {
        this.decorators.add(decorator);
        this.makeParentOf(decorator);
    }

    public List<Decorator> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public boolean hasDecorators() {
        return !this.decorators.isEmpty();
    }

    public GoloFunction createDecorator() {
        ExpressionStatement expr = Builders.refLookup("__$$_original");
        for (Decorator decorator : this.getDecorators()) {
            expr = decorator.wrapExpression(expr);
        }
        this.decoratorRef = SYMBOLS.next(this.name + "_decorator");
        return Builders.functionDeclaration(this.decoratorRef).decorator().inScope(this.scope).withParameters("__$$_original").returns(expr);
    }

    public ClosureReference asClosureReference() {
        if (this.scope != Scope.CLOSURE) {
            throw new IllegalStateException("Can't get a closure reference of a non-closure function");
        }
        return new ClosureReference(this);
    }

    @Override
    public void relink(ReferenceTable table) {
        this.block.relink(table);
    }

    @Override
    public void relinkTopLevel(ReferenceTable table) {
        this.block.relinkTopLevel(table);
    }

    public String toString() {
        return String.format("Function<name=%s, arity=%d, vararg=%s>", this.getName(), this.getArity(), this.isVarargs());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitFunction(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (Decorator deco : this.decorators) {
            deco.accept(visitor);
        }
        this.block.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getArity(), this.varargs);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoloFunction other = (GoloFunction)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.varargs != other.varargs) {
            return false;
        }
        return this.getArity() == other.getArity();
    }

    public static enum Scope {
        MODULE,
        AUGMENT,
        CLOSURE;

    }
}

