/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class CollectionLiteral
extends ExpressionStatement {
    private final Type type;
    private final List<ExpressionStatement> expressions = new LinkedList<ExpressionStatement>();

    CollectionLiteral(Type type) {
        this.type = type;
    }

    @Override
    public CollectionLiteral ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public CollectionLiteral add(Object expression) {
        ExpressionStatement expr = ExpressionStatement.of(expression);
        this.expressions.add(expr);
        this.makeParentOf(expr);
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public List<ExpressionStatement> getExpressions() {
        return this.expressions;
    }

    public String toString() {
        return this.type.toString() + this.expressions.toString();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCollectionLiteral(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (ExpressionStatement expression : this.expressions) {
            expression.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.expressions.contains(original) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.expressions.set(this.expressions.indexOf(original), (ExpressionStatement)newElement);
    }

    public static enum Type {
        array,
        list,
        set,
        map,
        tuple,
        vector,
        range;

    }
}

