/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import org.eclipse.golo.compiler.utils.NamingUtils;

public final class PackageAndClass {
    private final String packageName;
    private final String className;

    public PackageAndClass(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public static PackageAndClass fromString(String qualifiedName) {
        return new PackageAndClass(NamingUtils.extractTargetJavaPackage(qualifiedName), NamingUtils.extractTargetJavaClass(qualifiedName));
    }

    public PackageAndClass createInnerClass(String name) {
        return new PackageAndClass(this.packageName, this.className + "$" + name.replace('.', '$'));
    }

    public PackageAndClass inPackage(String qualifiedName) {
        return new PackageAndClass(qualifiedName, this.className);
    }

    public PackageAndClass inPackage(PackageAndClass parent) {
        return new PackageAndClass(parent.packageName(), this.className);
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public String toString() {
        if (this.packageName.isEmpty()) {
            return this.className;
        }
        return this.packageName + "." + this.className;
    }

    public String toJVMType() {
        return this.toString().replaceAll("\\.", "/");
    }

    public String toJVMRef() {
        return "L" + this.toJVMType() + ";";
    }

    public String mangledName() {
        return this.toString().replace('.', '$');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageAndClass that = (PackageAndClass)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }
}

