/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.AdapterFabric;
import gololang.CharRange;
import gololang.FunctionReference;
import gololang.IntRange;
import gololang.LongRange;
import gololang.Range;
import gololang.Tuple;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.AmbiguousFunctionReferenceException;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.Extractors;
import org.eclipse.golo.runtime.Loader;

public final class Predefined {
    private Predefined() {
        throw new UnsupportedOperationException("Why on earth are you trying to instantiate this class?");
    }

    public static void raise(Object message) {
        Predefined.require(message instanceof String, "raise requires a message as a String");
        throw new RuntimeException((String)message);
    }

    public static void raise(Object message, Object cause) {
        Predefined.require(message instanceof String, "raise requires a message as a String");
        Predefined.require(cause instanceof Throwable, "raise requires a cause as a Throwable");
        throw new RuntimeException((String)message, (Throwable)cause);
    }

    public static void print(Object obj) {
        System.out.print(obj);
    }

    public static void println(Object obj) {
        System.out.println(obj);
    }

    public static String readln() throws IOException {
        return System.console().readLine();
    }

    public static String readln(String message) throws IOException {
        System.out.print(message);
        return Predefined.readln();
    }

    public static String readPassword() throws IOException {
        return String.valueOf(System.console().readPassword());
    }

    public static String readPassword(String message) throws IOException {
        System.out.print(message);
        return Predefined.readPassword();
    }

    public static char[] secureReadPassword() throws IOException {
        return System.console().readPassword();
    }

    public static char[] secureReadPassword(String message) throws IOException {
        System.out.print(message);
        return Predefined.secureReadPassword();
    }

    public static void requireNotNull(Object obj) throws AssertionError {
        if (obj != null) {
            return;
        }
        throw new AssertionError((Object)"null reference encountered");
    }

    public static void require(Object condition, Object errorMessage) throws IllegalArgumentException, AssertionError {
        Predefined.requireNotNull(condition);
        Predefined.requireNotNull(errorMessage);
        if (condition instanceof Boolean && errorMessage instanceof String) {
            if (((Boolean)condition).booleanValue()) {
                return;
            }
            throw new AssertionError(errorMessage);
        }
        throw new IllegalArgumentException("Wrong parameters for require: expected (Boolean, String) but got (" + condition.getClass().getName() + ", " + errorMessage.getClass().getName() + ")");
    }

    public static Object newTypedArray(Class<?> type, int length) {
        return Array.newInstance(type, length);
    }

    public static Object range(Object from, Object to) {
        Predefined.require(from instanceof Integer || from instanceof Long || from instanceof Character, "from must either be an Integer, Long or Character");
        Predefined.require(to instanceof Integer || to instanceof Long || to instanceof Character, "to must either be an Integer, Long or Character");
        if (from instanceof Character && !(to instanceof Character) || to instanceof Character && !(from instanceof Character)) {
            throw new IllegalArgumentException("both bounds must be char for a char range");
        }
        if (to instanceof Character && from instanceof Character) {
            return new CharRange(((Character)from).charValue(), ((Character)to).charValue());
        }
        if (to instanceof Integer && from instanceof Integer) {
            return new IntRange((Integer)from, (Integer)to);
        }
        if (to instanceof Long && from instanceof Long) {
            return new LongRange((Long)from, (Long)to);
        }
        if (from instanceof Long) {
            return new LongRange((Long)from, ((Integer)to).intValue());
        }
        return new LongRange(((Integer)from).intValue(), (Long)to);
    }

    public static Object range(Object to) {
        Predefined.require(to instanceof Integer || to instanceof Long || to instanceof Character, "to must either be an Integer, Long or Character");
        if (to instanceof Integer) {
            return new IntRange((Integer)to);
        }
        if (to instanceof Long) {
            return new LongRange((Long)to);
        }
        return new CharRange(((Character)to).charValue());
    }

    public static Object reversedRange(Object from, Object to) {
        return ((Range)Predefined.range(from, to)).incrementBy(-1);
    }

    public static Object reversedRange(Object from) {
        return ((Range)Predefined.range(from)).reversed();
    }

    public static Object mapEntry(Object key, Object value) {
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    public static Object asInterfaceInstance(Object interfaceClass, Object target) {
        Predefined.require(interfaceClass instanceof Class, "interfaceClass must be a Class");
        Predefined.require(target instanceof FunctionReference, "target must be a FunctionReference");
        return MethodHandleProxies.asInterfaceInstance((Class)interfaceClass, ((FunctionReference)target).handle());
    }

    public static Object asFunctionalInterface(Object type, Object func) throws Throwable {
        Predefined.require(type instanceof Class, "type must be a Class");
        Predefined.require(func instanceof FunctionReference, "func must be a FunctionReference");
        Class theType = (Class)type;
        for (Method method : theType.getMethods()) {
            if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            configuration.put("interfaces", new Tuple(theType.getCanonicalName()));
            HashMap<String, FunctionReference> implementations = new HashMap<String, FunctionReference>();
            implementations.put(method.getName(), new FunctionReference(MethodHandles.dropArguments(((FunctionReference)func).handle(), 0, new Class[]{Object.class}), (String[])Arrays.stream(method.getParameters()).map(Parameter::getName).toArray(String[]::new)));
            configuration.put("implements", implementations);
            return new AdapterFabric().maker(configuration).newInstance(new Object[0]);
        }
        throw new RuntimeException("Could not convert " + func + " to a functional interface of type " + type);
    }

    public static Object isClosure(Object object) {
        return object instanceof FunctionReference;
    }

    public static FunctionReference fun(Object name, Object module, Object arity, Object varargs) throws Throwable {
        Predefined.require(name instanceof String, "name must be a String");
        Predefined.require(module instanceof Class, "module must be a module (e.g., foo.bar.Some.module)");
        Predefined.require(arity instanceof Integer, "name must be an Integer");
        Predefined.require(varargs instanceof Boolean, "varargs must be a Boolean");
        Class moduleClass = (Class)module;
        String functionName = (String)name;
        int functionArity = (Integer)arity;
        boolean isVarargs = (Boolean)varargs;
        Method targetMethod = null;
        Predicate<Method> candidate = Extractors.matchFunctionReference(functionName, functionArity, isVarargs);
        List validCandidates = Extractors.getMethods(moduleClass).filter(candidate).collect(Collectors.toList());
        if (validCandidates.size() == 1) {
            targetMethod = (Method)validCandidates.get(0);
            targetMethod.setAccessible(true);
            return Predefined.toFunctionReference(targetMethod, functionArity);
        }
        if (validCandidates.size() > 1) {
            throw new AmbiguousFunctionReferenceException("The reference to " + name + " in " + module + (functionArity < 0 ? "" : " with arity " + functionArity) + " is ambiguous");
        }
        Optional<Method> target = Predefined.getImportedFunctions(moduleClass).filter(candidate).findFirst();
        if (target.isPresent()) {
            return Predefined.toFunctionReference(target.get(), functionArity);
        }
        throw new NoSuchMethodException(name + " in " + module + (functionArity < 0 ? "" : " with arity " + functionArity));
    }

    public static FunctionReference fun(Object name, Object module, Object arity) throws Throwable {
        return Predefined.fun(name, module, arity, false);
    }

    public static FunctionReference fun(Object name, Object module) throws Throwable {
        return Predefined.fun(name, module, -1);
    }

    private static FunctionReference toFunctionReference(Method targetMethod, int functionArity) throws Throwable {
        String[] parameterNames = (String[])Arrays.stream(targetMethod.getParameters()).map(Parameter::getName).toArray(String[]::new);
        if (DecoratorsHelper.isMethodDecorated(targetMethod)) {
            return new FunctionReference(DecoratorsHelper.getDecoratedMethodHandle(targetMethod, functionArity), parameterNames);
        }
        return new FunctionReference(MethodHandles.publicLookup().unreflect(targetMethod), parameterNames);
    }

    private static Stream<Method> getImportedFunctions(Class<?> source) {
        return Extractors.getImportedNames(source).map(Loader.forClass(source)).filter(Objects::nonNull).flatMap(Extractors::getMethods).filter(Extractors::isPublic);
    }

    public static Object fileToText(Object file, Object encoding) throws Throwable {
        Charset charset = null;
        if (encoding instanceof String) {
            charset = Charset.forName((String)encoding);
        } else if (encoding instanceof Charset) {
            charset = (Charset)encoding;
        } else {
            throw new IllegalArgumentException("encoding must be either a string or a charset instance");
        }
        return new String(Files.readAllBytes(Predefined.pathFrom(file)), charset);
    }

    private static Path pathFrom(Object file) {
        if (file instanceof String) {
            return Paths.get((String)file, new String[0]);
        }
        if (file instanceof File) {
            return ((File)file).toPath();
        }
        if (file instanceof Path) {
            return (Path)file;
        }
        throw new IllegalArgumentException("file must be a string, a file or a path");
    }

    public static void textToFile(Object text, Object file) throws Throwable {
        Predefined.textToFile(text, file, Charset.defaultCharset());
    }

    public static void textToFile(Object text, Object file, Object charset) throws Throwable {
        Charset encoding;
        Predefined.require(text instanceof String, "text must be a string");
        if (charset instanceof String) {
            encoding = Charset.forName((String)charset);
        } else {
            Predefined.require(charset instanceof Charset, "not a charset");
            encoding = (Charset)charset;
        }
        String str = (String)text;
        Path path = Predefined.pathFrom(file);
        if ("-".equals(path.toString())) {
            System.out.write(str.getBytes(encoding));
        } else {
            Files.write(path, str.getBytes(encoding), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static boolean fileExists(Object file) {
        return Files.exists(Predefined.pathFrom(file), new LinkOption[0]);
    }

    public static String currentDir() throws Throwable {
        return new File(".").getCanonicalPath();
    }

    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static Class<?> objectArrayType() {
        return Object[].class;
    }

    public static Class<?> arrayTypeOf(Object klass) throws ClassNotFoundException {
        Predefined.require(klass instanceof Class, "klass must be a class");
        Class type = (Class)klass;
        return Class.forName("[L" + type.getName() + ";", true, type.getClassLoader());
    }

    public static Object charValue(Object obj) throws IllegalArgumentException {
        if (obj instanceof Character) {
            return obj;
        }
        if (obj instanceof Integer) {
            int value = (Integer)obj;
            return Character.valueOf((char)value);
        }
        if (obj instanceof Long) {
            long value = (Long)obj;
            return Character.valueOf((char)value);
        }
        if (obj instanceof Double) {
            double value = (Double)obj;
            return Character.valueOf((char)value);
        }
        if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            return Character.valueOf((char)value);
        }
        if (obj instanceof String) {
            return Character.valueOf(((String)obj).charAt(0));
        }
        throw new IllegalArgumentException("Expected a number or a string, but got: " + obj);
    }

    public static Object intValue(Object obj) throws IllegalArgumentException {
        if (obj instanceof Integer) {
            return obj;
        }
        if (obj instanceof Character) {
            char value = ((Character)obj).charValue();
            return (int)value;
        }
        if (obj instanceof Long) {
            long value = (Long)obj;
            return (int)value;
        }
        if (obj instanceof Double) {
            double value = (Double)obj;
            return (int)value;
        }
        if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            return (int)value;
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Expected a number or a string, but got: " + obj);
    }

    public static Object longValue(Object obj) throws IllegalArgumentException {
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof Character) {
            char value = ((Character)obj).charValue();
            return (long)value;
        }
        if (obj instanceof Integer) {
            int value = (Integer)obj;
            return (long)value;
        }
        if (obj instanceof Double) {
            double value = (Double)obj;
            return (long)value;
        }
        if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            return (long)value;
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Expected a number or a string, but got: " + obj);
    }

    public static Object doubleValue(Object obj) throws IllegalArgumentException {
        if (obj instanceof Double) {
            return obj;
        }
        if (obj instanceof Character) {
            char value = ((Character)obj).charValue();
            return (double)value;
        }
        if (obj instanceof Integer) {
            int value = (Integer)obj;
            return (double)value;
        }
        if (obj instanceof Long) {
            long value = (Long)obj;
            return (double)value;
        }
        if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            return (double)value;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Expected a number or a string, but got: " + obj);
    }

    public static Object floatValue(Object obj) throws IllegalArgumentException {
        if (obj instanceof Float) {
            return obj;
        }
        if (obj instanceof Character) {
            char value = ((Character)obj).charValue();
            return Float.valueOf(value);
        }
        if (obj instanceof Integer) {
            int value = (Integer)obj;
            return Float.valueOf(value);
        }
        if (obj instanceof Long) {
            long value = (Long)obj;
            return Float.valueOf(value);
        }
        if (obj instanceof Double) {
            double value = (Double)obj;
            return Float.valueOf((float)value);
        }
        if (obj instanceof String) {
            return Float.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Expected a number or a string, but got: " + obj);
    }

    public static Object removeByIndex(List<?> lst, Integer idx) {
        return lst.remove(idx);
    }

    public static Object box(Object obj) {
        return new AtomicReference<Object>(obj);
    }

    public static List<Object> list(Object ... values) {
        return new LinkedList<Object>(Arrays.asList(values));
    }

    public static Set<Object> set(Object ... values) {
        return new LinkedHashSet<Object>(Arrays.asList(values));
    }

    public static Object[] array(Object ... values) {
        return values;
    }

    public static List<Object> vector(Object ... values) {
        return new ArrayList<Object>(Arrays.asList(values));
    }

    public static Tuple tuple(Object ... values) {
        return new Tuple(values);
    }

    public static Map<Object, Object> map(Tuple ... items) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        for (Tuple t : items) {
            m.put(t.get(0), t.get(1));
        }
        return m;
    }
}

