/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.util;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ReflectionUtil {
    protected static Logger LOGGER = LogManager.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static <T> Optional<T> construct(Class<? extends T> clazz) {
        try {
            return Optional.of(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            LOGGER.error("Could not construct instance of class: " + String.valueOf(clazz), (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> Stream<? extends T> construct(Stream<Class<? extends T>> classes) {
        return classes.filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).flatMap(clazz -> ReflectionUtil.construct(clazz).stream());
    }

    public static <T> Stream<? extends T> construct(Collection<Class<? extends T>> classes) {
        return ReflectionUtil.construct(classes.stream());
    }

    public static <T> List<? extends T> constructToList(Stream<Class<? extends T>> classes) {
        return ReflectionUtil.construct(classes).collect(Collectors.toList());
    }

    public static <T> List<? extends T> constructToList(Collection<Class<? extends T>> classes) {
        return ReflectionUtil.constructToList(classes.stream());
    }
}

