/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.BasicActionHandler;
import org.eclipse.glsp.server.features.core.model.ModelFactory;
import org.eclipse.glsp.server.features.core.model.RequestBoundsAction;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.core.model.SetModelAction;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.utils.ClientOptions;

public class RequestModelActionHandler
extends BasicActionHandler<RequestModelAction> {
    @Inject
    protected ModelFactory modelFactory;
    @Inject
    private ModelSourceWatcher modelSourceWatcher;

    @Override
    public List<Action> executeAction(RequestModelAction action, GModelState modelState) {
        GModelRoot model = this.modelFactory.loadModel(action, modelState);
        modelState.setRoot(model);
        modelState.setClientOptions(action.getOptions());
        this.modelSourceWatcher.startWatching(modelState);
        boolean needsClientLayout = ClientOptions.getBoolValue(action.getOptions(), "needsClientLayout");
        Action responseAction = needsClientLayout ? new RequestBoundsAction((GModelRoot)modelState.getRoot()) : new SetModelAction((GModelRoot)modelState.getRoot());
        return this.listOf(responseAction);
    }
}

