/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.di;

import java.util.function.Consumer;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.di.GLSPModule;
import org.eclipse.glsp.server.diagram.DiagramConfiguration;
import org.eclipse.glsp.server.diagram.DiagramConfigurationRegistry;
import org.eclipse.glsp.server.features.contextactions.ContextActionsProvider;
import org.eclipse.glsp.server.features.contextactions.ContextActionsProviderRegistry;
import org.eclipse.glsp.server.features.directediting.ContextEditValidator;
import org.eclipse.glsp.server.features.directediting.ContextEditValidatorRegistry;
import org.eclipse.glsp.server.features.navigation.NavigationTargetProvider;
import org.eclipse.glsp.server.features.navigation.NavigationTargetProviderRegistry;
import org.eclipse.glsp.server.features.toolpalette.DefaultToolPaletteItemProvider;
import org.eclipse.glsp.server.features.toolpalette.ToolPaletteItemProvider;
import org.eclipse.glsp.server.internal.action.DefaultActionDispatcher;
import org.eclipse.glsp.server.internal.di.DIActionHandlerRegistry;
import org.eclipse.glsp.server.internal.di.DIActionRegistry;
import org.eclipse.glsp.server.internal.di.DIContextActionsProviderRegistry;
import org.eclipse.glsp.server.internal.di.DIContextEditValidatorRegistry;
import org.eclipse.glsp.server.internal.di.DIDiagramConfigurationRegistry;
import org.eclipse.glsp.server.internal.di.DINavigationTargetProviderRegistry;
import org.eclipse.glsp.server.internal.di.DIOperationHandlerRegistry;
import org.eclipse.glsp.server.internal.di.MultiBindingDefaults;
import org.eclipse.glsp.server.internal.json.DefaultGraphGsonConfiguratorFactory;
import org.eclipse.glsp.server.jsonrpc.DefaultClientSessionManager;
import org.eclipse.glsp.server.jsonrpc.DefaultGLSPServer;
import org.eclipse.glsp.server.jsonrpc.GraphGsonConfiguratorFactory;
import org.eclipse.glsp.server.model.DefaultModelStateProvider;
import org.eclipse.glsp.server.model.ModelStateProvider;
import org.eclipse.glsp.server.operations.OperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.utils.MultiBinding;

public abstract class DefaultGLSPModule
extends GLSPModule {
    @Override
    public void configure() {
        super.configure();
        this.configureMultiBinding();
    }

    protected void configureMultiBinding() {
        this.configure(MultiBinding.create(Action.class).setAnnotationName("ClientActionHandler"), this::configureClientActions);
        this.configure(MultiBinding.create(ActionHandler.class), this::configureActionHandlers);
        this.configure(MultiBinding.create(OperationHandler.class), this::configureOperationHandlers);
        this.configure(MultiBinding.create(DiagramConfiguration.class), this::configureDiagramConfigurations);
        this.configure(MultiBinding.create(ContextActionsProvider.class), this::configureContextActionsProviders);
        this.configure(MultiBinding.create(ContextEditValidator.class), this::configureContextEditValidators);
        this.configure(MultiBinding.create(NavigationTargetProvider.class), this::configureNavigationTargetProviders);
    }

    protected <T> void configure(MultiBinding<T> binding, Consumer<MultiBinding<T>> configurator) {
        configurator.accept(binding);
        binding.applyBinding(this.binder());
    }

    protected abstract void configureDiagramConfigurations(MultiBinding<DiagramConfiguration> var1);

    protected void configureClientActions(MultiBinding<Action> binding) {
        binding.addAll(MultiBindingDefaults.DEFAULT_CLIENT_ACTIONS);
    }

    protected void configureActionHandlers(MultiBinding<ActionHandler> binding) {
        binding.addAll(MultiBindingDefaults.DEFAULT_ACTION_HANDLERS);
    }

    protected void configureOperationHandlers(MultiBinding<OperationHandler> binding) {
        binding.addAll(MultiBindingDefaults.DEFAULT_OPERATION_HANDLERS);
    }

    protected void configureContextActionsProviders(MultiBinding<ContextActionsProvider> binding) {
    }

    protected void configureContextEditValidators(MultiBinding<ContextEditValidator> binding) {
    }

    protected void configureNavigationTargetProviders(MultiBinding<NavigationTargetProvider> binding) {
    }

    @Override
    protected Class<? extends GLSPServer> bindGLSPServer() {
        return DefaultGLSPServer.class;
    }

    @Override
    protected Class<? extends GraphGsonConfiguratorFactory> bindGraphGsonConfiguratorFactory() {
        return DefaultGraphGsonConfiguratorFactory.class;
    }

    @Override
    protected Class<? extends ModelStateProvider> bindModelStateProvider() {
        return DefaultModelStateProvider.class;
    }

    @Override
    protected Class<? extends ActionDispatcher> bindActionDispatcher() {
        return DefaultActionDispatcher.class;
    }

    @Override
    protected Class<? extends ToolPaletteItemProvider> bindToolPaletteItemProvider() {
        return DefaultToolPaletteItemProvider.class;
    }

    @Override
    protected Class<? extends ActionRegistry> bindActionRegistry() {
        return DIActionRegistry.class;
    }

    @Override
    protected Class<? extends DiagramConfigurationRegistry> bindDiagramConfigurationRegistry() {
        return DIDiagramConfigurationRegistry.class;
    }

    @Override
    protected Class<? extends ActionHandlerRegistry> bindActionHandlerRegistry() {
        return DIActionHandlerRegistry.class;
    }

    @Override
    protected Class<? extends OperationHandlerRegistry> bindOperationHandlerRegistry() {
        return DIOperationHandlerRegistry.class;
    }

    @Override
    protected Class<? extends ContextActionsProviderRegistry> bindContextActionsProviderRegistry() {
        return DIContextActionsProviderRegistry.class;
    }

    @Override
    protected Class<? extends NavigationTargetProviderRegistry> bindNavigationTargetProviderRegistry() {
        return DINavigationTargetProviderRegistry.class;
    }

    @Override
    protected Class<? extends ContextEditValidatorRegistry> bindContextEditValidatorRegistry() {
        return DIContextEditValidatorRegistry.class;
    }

    @Override
    protected ClientSessionManager getClientSessionManager() {
        return DefaultClientSessionManager.INSTANCE;
    }
}

