/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.inject.Inject;
import java.util.Collection;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcClient;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcServer;
import org.eclipse.glsp.server.jsonrpc.GsonConfigurator;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.websocket.WebSocketEndpoint;

public class GLSPServerEndpoint
extends WebSocketEndpoint<GLSPJsonrpcClient> {
    public static final int MAX_TEXT_MESSAGE_BUFFER_SIZE = 0x800000;
    @Inject
    private GLSPServer glspServer;
    @Inject
    private GsonConfigurator gsonConfigurator;

    protected void configure(Launcher.Builder<GLSPJsonrpcClient> builder) {
        builder.setLocalService((Object)this.glspServer);
        builder.setRemoteInterface(GLSPJsonrpcClient.class);
        builder.configureGson(arg_0 -> ((GsonConfigurator)this.gsonConfigurator).configureGsonBuilder(arg_0));
    }

    protected void connect(Collection<Object> localServices, GLSPJsonrpcClient remoteProxy) {
        localServices.stream().filter(GLSPJsonrpcServer.class::isInstance).map(GLSPJsonrpcServer.class::cast).forEach(ca -> ca.connect((GLSPClient)remoteProxy));
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxTextMessageBufferSize(0x800000);
        super.onOpen(session, config);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.glspServer.shutdown();
    }
}

