/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijavaeebase.OSGiJavaEEArchive;
import org.osgi.framework.Bundle;

public class WAB
extends OSGiJavaEEArchive {
    private static final String LIB_DIR = "WEB-INF/lib/";
    private static final String CLASSES_DIR = "WEB-INF/classes/";

    public WAB(Bundle host, Bundle[] fragments) {
        super(fragments, host);
    }

    protected synchronized void init() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(Arrays.asList(this.fragments));
        bundles.add(0, this.host);
        for (Bundle b : bundles) {
            final OSGiBundleArchive archive = this.getArchive(b);
            for (final String entry : Collections.list(archive.entries())) {
                if (this.getEntries().containsKey(entry)) continue;
                OSGiJavaEEArchive.ArchiveEntry archiveEntry = new OSGiJavaEEArchive.ArchiveEntry(){

                    public String getName() {
                        return entry;
                    }

                    public URI getURI() throws URISyntaxException {
                        return archive.getEntryURI(entry);
                    }

                    public InputStream getInputStream() throws IOException {
                        return archive.getEntry(entry);
                    }
                };
                this.getEntries().put(entry, archiveEntry);
            }
        }
        OSGiJavaEEArchive.EffectiveBCP bcp = this.getEffectiveBCP();
        bcp.accept(new OSGiJavaEEArchive.BCPEntry.BCPEntryVisitor(){
            private int i = 0;

            public void visitDir(final OSGiJavaEEArchive.DirBCPEntry bcpEntry) {
                try {
                    if (bcpEntry.getName().equals(WAB.CLASSES_DIR)) {
                        return;
                    }
                    ReadableArchive subArchive = WAB.this.getArchive(bcpEntry.getBundle()).getSubArchive(bcpEntry.getName());
                    for (final String subEntry : Collections.list(subArchive.entries())) {
                        OSGiJavaEEArchive.ArchiveEntry archiveEntry = new OSGiJavaEEArchive.ArchiveEntry(){

                            public String getName() {
                                return WAB.CLASSES_DIR + subEntry;
                            }

                            public URI getURI() throws URISyntaxException {
                                return bcpEntry.getBundle().getEntry(bcpEntry.getName() + subEntry).toURI();
                            }

                            public InputStream getInputStream() throws IOException {
                                try {
                                    return this.getURI().toURL().openStream();
                                }
                                catch (URISyntaxException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                        WAB.this.getEntries().put(archiveEntry.getName(), archiveEntry);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void visitJar(final OSGiJavaEEArchive.JarBCPEntry bcpEntry) {
                String newJarName;
                String jarName;
                if (bcpEntry.getName().startsWith(WAB.LIB_DIR) && bcpEntry.getName().endsWith(".jar") && (jarName = bcpEntry.getName().substring(WAB.LIB_DIR.length())).indexOf("/") == -1) {
                    return;
                }
                if (bcpEntry.getName().equals(".")) {
                    newJarName = "WEB-INF/lib/Bundle" + bcpEntry.getBundle().getBundleId() + ".jar";
                    WAB.this.getEntries().put(newJarName, new OSGiJavaEEArchive.ArchiveEntry(){

                        public String getName() {
                            return newJarName;
                        }

                        public URI getURI() throws URISyntaxException {
                            return WAB.this.getArchive(bcpEntry.getBundle()).getURI();
                        }

                        public InputStream getInputStream() throws IOException {
                            return WAB.this.getArchive(bcpEntry.getBundle()).getInputStream();
                        }
                    });
                } else {
                    newJarName = "WEB-INF/lib/Bundle" + bcpEntry.getBundle().getBundleId() + "-" + bcpEntry.getName().replace('/', '-') + ".jar";
                    WAB.this.getEntries().put(newJarName, new OSGiJavaEEArchive.ArchiveEntry(){

                        public String getName() {
                            return newJarName;
                        }

                        public URI getURI() throws URISyntaxException {
                            return bcpEntry.getBundle().getEntry(bcpEntry.getName()).toURI();
                        }

                        public InputStream getInputStream() throws IOException {
                            try {
                                return this.getURI().toURL().openStream();
                            }
                            catch (URISyntaxException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
        });
    }
}

