/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.shared.ArchivistUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class MemoryMappedArchive
extends JarArchive
implements ReadableArchive {
    private URI uri;
    byte[] file;

    protected MemoryMappedArchive() {
    }

    public MemoryMappedArchive(InputStream is) throws IOException {
        this.read(is);
    }

    public MemoryMappedArchive(byte[] bits) {
        this.file = bits;
    }

    public byte[] getByteArray() {
        return this.file;
    }

    private void read(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArchivistUtils.copy((InputStream)is, (OutputStream)baos);
        this.file = baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(URI uri) throws IOException {
        File in = new File(uri);
        if (!in.exists()) {
            throw new FileNotFoundException(uri.getSchemeSpecificPart());
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(in);
            this.read(is);
        }
    }

    public MemoryMappedArchive(ReadableArchive source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(baos);
        Enumeration elements = source.entries();
        while (elements.hasMoreElements()) {
            String elementName = (String)elements.nextElement();
            InputStream is = source.getEntry(elementName);
            jos.putNextEntry(new ZipEntry(elementName));
            ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)jos);
            is.close();
            jos.flush();
            jos.closeEntry();
        }
        jos.close();
        this.file = baos.toByteArray();
    }

    public void close() throws IOException {
    }

    public boolean delete() {
        return false;
    }

    public Enumeration entries() {
        return this.entries(false).elements();
    }

    public Collection<String> getDirectories() throws IOException {
        return this.entries(true);
    }

    private Vector<String> entries(boolean directory) {
        Vector<String> entries = new Vector<String>();
        try {
            ZipEntry ze;
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
            while ((ze = jis.getNextEntry()) != null) {
                if (ze.isDirectory() != directory) continue;
                entries.add(ze.getName());
            }
            jis.close();
        }
        catch (IOException ioe) {
            Logger.getAnonymousLogger().log(Level.WARNING, ioe.getMessage(), ioe);
        }
        return entries;
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        return false;
    }

    public String getPath() {
        return null;
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return this.file.length;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        InputStream is = this.getEntry(name);
        if (is != null) {
            MemoryMappedArchive archive = new MemoryMappedArchive(is);
            is.close();
            return archive;
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.getEntry(name) != null;
    }

    public InputStream getEntry(String name) throws IOException {
        ZipEntry ze;
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(name)) continue;
            return new BufferedInputStream(jis);
        }
        return null;
    }

    @Override
    public JarEntry getJarEntry(String name) {
        try {
            JarEntry ze;
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
            while ((ze = jis.getNextJarEntry()) != null) {
                if (!ze.getName().equals(name)) continue;
                return ze;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public long getEntrySize(String name) {
        try {
            ZipEntry ze;
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
            while ((ze = jis.getNextEntry()) != null) {
                if (!ze.getName().equals(name)) continue;
                return ze.getSize();
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return 0L;
    }

    public Manifest getManifest() throws IOException {
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        Manifest m = jis.getManifest();
        jis.close();
        return m;
    }

    public boolean renameTo(String name) {
        return false;
    }

    @Override
    public String getName() {
        return "";
    }
}

