/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableRowGroupRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"align", "bgColor", "char", "charOff", "dir", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.isAboveColumnHeader()) {
            this.renderGroupHeader(context, group, writer);
            this.renderColumnHeaders(context, group, writer);
        } else {
            this.renderColumnHeaders(context, group, writer);
            this.renderGroupHeader(context, group, writer);
        }
        group.setRowKey(null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.getRowCount() == 0) {
            this.log("encodeChildren", "Cannot render data, row count is zero");
            this.renderEmptyDataColumn(context, group, writer);
            return;
        }
        RowKey[] rowKeys = group.getRenderedRowKeys();
        if (rowKeys == null) {
            this.log("encodeChildren", "Cannot render data, RowKey array is null");
            return;
        }
        for (int i = 0; i < rowKeys.length; ++i) {
            group.setRowKey(rowKeys[i]);
            if (!group.isRowAvailable()) {
                this.log("encodeChildren", "Cannot render data, row not available");
                break;
            }
            this.renderEnclosingTagStart(context, group, writer, i);
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered()) {
                    this.log("encodeChildren", "TableColumn not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent((UIComponent)col, context);
            }
            this.renderEnclosingTagEnd(writer);
        }
        group.setRowKey(null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.getRowCount() == 0) {
            this.log("encodeEnd", "Column, group, and table footers not rendered, row count is zero");
            return;
        }
        if (group.isAboveColumnFooter()) {
            this.renderGroupFooter(context, group, writer);
            this.renderColumnFooters(context, group, writer);
        } else {
            this.renderColumnFooters(context, group, writer);
            this.renderGroupFooter(context, group, writer);
        }
        Table table = group.getTableAncestor();
        if (table.getRowCount() > 0) {
            this.renderTableColumnFooters(context, group, writer);
        } else {
            this.log("encodeEnd", "Table column footers not rendered, row count is zero");
        }
        group.setRowKey(null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEmptyDataColumn(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEmptyDataColumn", "Cannot render empty data column, TableRowGroup is null");
            return;
        }
        this.renderEnclosingTagStart(context, component, writer, -1);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(component.getEmptyDataColumn(), context);
        this.renderEnclosingTagEnd(writer);
    }

    protected void renderColumnFooters(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderColumnFooters", "Cannot render column footers, TableRowGroup is null");
            return;
        }
        Map map = this.getColumnFooterMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            if (c > 0 && !component.isMultipleColumnFooters()) {
                this.log("renderColumnFooters", "Multiple column footers not rendered, nothing to display");
                break;
            }
            boolean renderStartElement = true;
            List list = (List)map.get(new Integer(c));
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (!col.isRendered()) {
                    this.log("renderColumnFooters", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent footer = col.getColumnFooter();
                if (footer == null || !footer.isRendered()) {
                    this.log("renderColumnFooters", "Column footer not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_columnFooterBar:" + c), null);
                    if (component.isCollapsed()) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(footer, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderColumnHeaders(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderColumnHeaders", "Cannot render column headers, TableRowGroup is null");
            return;
        }
        Map map = this.getColumnHeaderMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            boolean renderStartElement = true;
            List list = (List)map.get(new Integer(c));
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (!col.isRendered()) {
                    this.log("renderColumnHeaders", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent header = col.getColumnHeader();
                if (header == null || !header.isRendered()) {
                    this.log("renderColumnHeaders", "Column header not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_columnHeaderBar:" + c), null);
                    if (component.isCollapsed() && table != null && table.getColumnHeadersCount() > 1) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(header, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderTableColumnFooters(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTableColumnFooters", "Cannot render table column footers, TableRowGroup is null");
            return;
        }
        Map map = this.getColumnFooterMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            if (c > 0 && table != null && !component.isMultipleTableColumnFooters()) {
                this.log("renderTableColumnFooters", "Multiple table column footers not rendered, nothing to display");
                break;
            }
            boolean renderStartElement = true;
            List list = (List)map.get(new Integer(c));
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (!col.isRendered()) {
                    this.log("renderTableColumnFooters", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent footer = col.getTableColumnFooter();
                if (footer == null || !footer.isRendered()) {
                    this.log("renderTableColumnFooters", "Table column footer not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableColumnFooterBar:" + c), null);
                    if (component.isCollapsed() && table.getColumnHeadersCount() > 1) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(footer, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderGroupFooter(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderGroupFooter", "Cannot render group footer, TableRowGroup is null");
            return;
        }
        UIComponent footer = component.getGroupFooter();
        if (footer == null || !footer.isRendered()) {
            this.log("renderGroupFooter", "Group footer not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_groupFooterBar"), null);
        if (component.isCollapsed()) {
            writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
        }
        RenderingUtilities.renderComponent(footer, context);
        writer.endElement("tr");
    }

    protected void renderGroupHeader(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderGroupHeader", "Cannot render group header, TableRowGroup is null");
            return;
        }
        UIComponent header = component.getGroupHeader();
        if (header == null || !header.isRendered()) {
            this.log("renderGroupHeader", "Group header not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_groupHeaderBar"), null);
        RenderingUtilities.renderComponent(header, context);
        writer.endElement("tr");
    }

    protected void renderEnclosingTagStart(FacesContext context, TableRowGroup component, ResponseWriter writer, int index) throws IOException {
        String s;
        String styleClass;
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, TableRowGroup is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String[] styleClasses = this.getRowStyleClasses(component);
        String string = styleClass = index > -1 && styleClasses.length > 0 ? styleClasses[index % styleClasses.length] : null;
        if (component.isSelected()) {
            s = theme.getStyleClass("TABLE_SELECT_ROW");
            String string2 = styleClass = styleClass != null ? styleClass + " " + s : s;
        }
        if (component.isCollapsed()) {
            s = theme.getStyleClass("HIDDEN");
            styleClass = styleClass != null ? styleClass + " " + s : s;
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, styleClass);
        if (component.getToolTip() != null) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, stringAttributes);
    }

    protected void renderEnclosingTagEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    private Map getColumnFooterMap(TableRowGroup component) {
        Map map = this.getColumnHeaderMap(component);
        if (map.size() == 0) {
            this.log("getColumnFooterMap", "Cannot obtain column footer map");
            return map;
        }
        HashMap newMap = new HashMap();
        for (int i = 0; i < map.size(); ++i) {
            newMap.put(new Integer(i), map.get(new Integer(map.size() - i - 1)));
        }
        List newList = (List)newMap.get(new Integer(0));
        for (int c = 1; c < newMap.size(); ++c) {
            List list = (List)newMap.get(new Integer(c));
            for (int i = list.size() - 1; i >= 0; --i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (col.getTableColumnChildren().hasNext()) continue;
                int colspan = 0;
                for (int k = i - 1; k >= 0; --k) {
                    TableColumn prevCol = (TableColumn)((Object)list.get(k));
                    if (!prevCol.getTableColumnChildren().hasNext()) continue;
                    colspan += prevCol.getColumnCount();
                }
                newList.add(colspan, col);
                list.remove(i);
            }
        }
        return newMap;
    }

    private Map getColumnHeaderMap(TableRowGroup component) {
        HashMap map = new HashMap();
        if (component == null) {
            this.log("getColumnHeaderMap", "Cannot obtain column header map, TableRowGroup is null");
            return map;
        }
        Iterator kids = component.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = (TableColumn)((Object)kids.next());
            this.initColumnHeaderMap(col, map, 0);
        }
        return map;
    }

    private String getId(UIComponent component, String id) {
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        return clientId + ':' + id;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private String[] getRowStyleClasses(TableRowGroup component) {
        String values;
        String string = values = component != null ? component.getStyleClasses() : null;
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private void initColumnHeaderMap(TableColumn component, Map map, int level) {
        Integer key;
        ArrayList<TableColumn> list;
        if (component == null) {
            this.log("initColumnHeaderMap", "Cannot initialize column header map, TableColumn is null");
            return;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            ArrayList newList = new ArrayList();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered()) continue;
                this.initColumnHeaderMap(col, map, level + 1);
            }
        }
        if ((list = (ArrayList<TableColumn>)map.get(key = new Integer(level))) == null) {
            list = new ArrayList<TableColumn>();
        }
        list.add(component);
        map.put(key, list);
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

