/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyWaiter;

class UnicastReplyWaiter
extends ReplyWaiter {
    private BrokerAddress toBroker;

    public UnicastReplyWaiter(BrokerAddress to, short replyType) {
        super(to, replyType);
        this.toBroker = to;
    }

    @Override
    public void onReply(BrokerAddress remote, GPacket reply) {
        this.waitStatus = 200;
        this.notifyAll();
    }

    @Override
    public void onAddParticipant(BrokerAddress remote) {
    }

    @Override
    public void onRemoveParticipant(BrokerAddress remote, boolean goodbyed, boolean shutdown) {
        if (this.waitStatus != 0) {
            return;
        }
        this.participants.remove(remote);
        if (!remote.equals(this.toBroker) && !shutdown) {
            return;
        }
        this.waitStatus = goodbyed ? 410 : 408;
        this.notifyAll();
    }

    @Override
    public ReplyStatus getReply() {
        return (ReplyStatus)this.replies.get(this.toBroker);
    }

    public BrokerAddress getToBroker() {
        return this.toBroker;
    }
}

