/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.HandshakeInProgressException;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLinkWriter;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerListLock;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class BrokerLink
extends Thread {
    private static boolean DEBUG = false;
    private boolean connected = false;
    private boolean expectBrokerInfoPkt = true;
    private boolean expectBrokerInfoReplyPkt = false;
    private Object handshakeLock = new Object();
    private boolean handshakeSent = false;
    private Socket conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private BrokerLinkWriter writer = null;
    private BrokerAddressImpl self;
    private BrokerAddressImpl remote;
    private ClusterImpl parent = null;
    private boolean linkInitDone = false;
    private Object linkInitWaitObject = null;
    private boolean autoConnect = false;
    private BrokerListLock brokerListLock = new BrokerListLock();
    private static Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private long createLinkFailures = 0L;
    private static Hashtable waitingMasterLogs = new Hashtable();
    private boolean readActive = true;
    protected static final long DEFAULT_INIT_WAIT_TIME = 180000L;
    protected static final long DEFAULT_INIT_WAIT_INTERVAL = 15000L;
    private static final long initWaitTimeSeconds = Globals.getConfig().getLongProperty("imq.cluster.waitConnectionInitTimeout", 180L);
    protected static final long INIT_WAIT_TIME = initWaitTimeSeconds * 1000L;
    protected static final long RECONNECT_INTERVAL = 5000L;
    private boolean firstInfoSent = false;
    private boolean firstReceive = true;
    private AtomicBoolean pingLogging = new AtomicBoolean(false);
    private static final FaultInjection fi = FaultInjection.getInjection();
    private String oomStr = null;
    private static SSLSocketFactory factory = null;

    public BrokerLink(BrokerAddressImpl self, BrokerAddressImpl remote, ClusterImpl parent) {
        this.self = self;
        this.remote = remote;
        this.oomStr = br.getKString("B0019") + " [" + this.getRemoteString() + "]";
        this.setName("BrokerLink:" + this.getRemoteString());
        this.parent = parent;
        this.linkInitDone = false;
        this.linkInitWaitObject = new Object();
        this.setDaemon(true);
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public boolean getAutoConnect() {
        return this.autoConnect;
    }

    private void setRemote(BrokerAddressImpl remote) {
        this.remote = remote;
        this.setName("BrokerLink:" + this.getRemoteString());
    }

    protected BrokerAddressImpl getRemote() {
        return this.remote;
    }

    protected String getRemoteString() {
        return BrokerLink.getRemoteString(this.conn, this.remote);
    }

    protected static String getRemoteString(Socket s, BrokerAddressImpl remoteBroker) {
        String rs = BrokerLink.getRealRemoteString(s);
        if (rs == null) {
            return remoteBroker.toString();
        }
        return remoteBroker.toString() + "[" + rs + "]";
    }

    private static String getRealRemoteString(Socket s) {
        if (s == null || s.isClosed()) {
            return null;
        }
        return s.getRemoteSocketAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLinkInit(long initWaitTime) {
        if (DEBUG) {
            logger.log(4, "BrokerLink.waitLinkInit : " + this);
        }
        long endtime = System.currentTimeMillis() + initWaitTime;
        long waittime = initWaitTime;
        if (waittime > 15000L) {
            waittime = 15000L;
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            while (!this.linkInitDone) {
                try {
                    logger.log(8, "B1150", (Object)this.getRemoteString());
                    this.linkInitWaitObject.wait(waittime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.linkInitDone) break;
                long curtime = System.currentTimeMillis();
                if (curtime >= endtime) {
                    logger.log(16, br.getKString("B2191", String.valueOf(initWaitTimeSeconds), this.getRemoteString()));
                    break;
                }
                waittime = endtime - curtime;
                if (waittime <= 15000L) continue;
                waittime = 15000L;
            }
        }
        if (DEBUG) {
            logger.log(4, "Returning from BrokerLink.waitLinkInit : " + this);
        }
    }

    public synchronized void setFlowControl(boolean enabled) {
        if (this.writer == null) {
            return;
        }
        this.writer.setFlowControl(enabled);
    }

    protected synchronized boolean isModified(Object o) {
        return o != this.writer;
    }

    public synchronized Object sendPacket(GPacket gp) throws IOException {
        return this.sendPacket(gp, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object sendPacket(GPacket gp, boolean close, boolean urgent) throws IOException {
        short type = gp.getType();
        if (DEBUG) {
            logger.log(8, "BrokerLink.sendPacket(" + ProtocolGlobals.getPacketTypeString(type) + ")");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.getRemoteString());
        }
        Object object = this.handshakeLock;
        synchronized (object) {
            if (type != 46) {
                if (BrokerLink.fi.FAULT_INJECTION) {
                    FaultInjection faultInjection = fi;
                    synchronized (faultInjection) {
                        if (fi.checkFault("cluster.link.handshakeInprogressException", null)) {
                            fi.unsetFault("cluster.link.handshakeInprogressException");
                            throw new HandshakeInProgressException(br.getKString("B2295", ProtocolGlobals.getPacketTypeDisplayString(type), this));
                        }
                    }
                }
                if (!this.handshakeSent) {
                    throw new HandshakeInProgressException(br.getKString("B2295", ProtocolGlobals.getPacketTypeDisplayString(type), this));
                }
            }
        }
        if (type != 46) {
            if (!this.firstInfoSent) {
                if (type == 49) {
                    this.firstInfoSent = true;
                } else {
                    GPacket p = this.parent.getFirstInfoPacket();
                    this.firstInfoSent = true;
                    if (p != null) {
                        this.sendPacket(p);
                    }
                }
            } else if (type == 49) {
                return this.writer;
            }
        }
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && (type == 33 || type == 34) || ClusterManagerImpl.isDEBUG_CLUSTER_ALL()) {
            logger.log(8, "SENDING PACKET : " + this + "\n" + gp.toLongString());
            if (logger.getLevel() <= 4 && gp.getPayload() != null) {
                byte[] buf = gp.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump(buf, Integer.MAX_VALUE));
            }
        }
        this.writer.sendPacket(gp, close, urgent);
        return this.writer;
    }

    public synchronized void sendPacket(Packet p) throws IOException {
        this.sendPacket(p, false);
    }

    public synchronized void sendPacket(Packet p, boolean close) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.sendPacket(Packet)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.getRemoteString());
        }
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && p.getPacketType() == 7 || ClusterManagerImpl.isDEBUG_CLUSTER_ALL()) {
            logger.log(8, "SENDING PACKET : " + this + "\nPacket = " + p + "\n");
        }
        this.writer.sendPacket(p, close);
    }

    private void linkDown() {
        this.linkDown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkDown(boolean broken) {
        if (DEBUG) {
            logger.log(4, "BrokerLink.linkDown()");
        }
        if (ClusterManagerImpl.isDEBUG_CLUSTER_ALL() || ClusterManagerImpl.isDEBUG_CLUSTER_CONN()) {
            logger.log(8, "Link down\n\tRemote BrokerAddress = " + this.getRemoteString() + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        if (DEBUG) {
            logger.log(2, "Cluster connection closed.");
        }
        this.brokerListLock.lock();
        try {
            BrokerLink brokerLink = this;
            synchronized (brokerLink) {
                block17: {
                    if (this.writer != null) break block17;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connected = false;
                    return;
                }
                this.writer.shutdown();
                this.writer = null;
                try {
                    this.is.close();
                    this.os.close();
                    this.conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connected = false;
                this.is = null;
                this.os = null;
            }
            this.parent.removeBroker(this.remote, this, broken);
        }
        finally {
            this.brokerListLock.unlock();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized SSLSocketFactory getTrustSocketFactory() throws Exception {
        if (factory == null) {
            SSLContext ctx = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
            ctx.init(null, tm, null);
            factory = ctx.getSocketFactory();
        }
        return factory;
    }

    public static Socket makeSocket(BrokerAddressImpl remoteBroker, ClusterImpl parent, boolean configure, Map props) throws Exception {
        Socket socket = null;
        PortMapperEntry pme = BrokerLink.getRealRemotePort(remoteBroker);
        if (pme == null) {
            throw new BrokerException(br.getKString("B4256", BrokerLink.getRemoteString(null, remoteBroker)));
        }
        if (!pme.getProtocol().equalsIgnoreCase(parent.getTransport())) {
            throw new BrokerException(br.getKString("B4208", parent.getTransport(), pme.getProtocol()));
        }
        int remotePort = pme.getPort();
        String h = pme.getProperty("hostaddr");
        InetAddress laddr = parent.getListenHost();
        boolean nodelay = parent.getTCPNodelay();
        boolean ssl = false;
        if (pme.getProtocol().equalsIgnoreCase("ssl")) {
            nodelay = parent.getSSLNodelay();
            ssl = true;
            props.put("ssl", "true");
        }
        socket = laddr == null ? (ssl ? BrokerLink.makeSSLSocket(h == null ? remoteBroker.getHost() : InetAddress.getByName(h), remotePort, null, 0) : new Socket(h == null ? remoteBroker.getHost() : InetAddress.getByName(h), remotePort)) : (ssl ? BrokerLink.makeSSLSocket(h == null ? remoteBroker.getHost() : InetAddress.getByName(h), remotePort, laddr, 0) : new Socket(h == null ? remoteBroker.getHost() : InetAddress.getByName(h), remotePort, laddr, 0));
        if (configure) {
            try {
                socket.setTcpNoDelay(nodelay);
            }
            catch (SocketException e) {
                logger.log(16, "BrokerLink.makeSocket(" + remoteBroker + ").setTcpNoDelay(" + nodelay + "): " + e.toString());
            }
        }
        return socket;
    }

    private static Socket makeSSLSocket(InetAddress host, int port, InetAddress localhost, int localport) throws Exception {
        Socket sock;
        if (Globals.getConfig().getBooleanProperty("imq.cluster.trust_all", true)) {
            SSLSocketFactory sslFactory = BrokerLink.getTrustSocketFactory();
            sock = localhost == null ? sslFactory.createSocket(host, port) : sslFactory.createSocket(host, port, localhost, localport);
        } else {
            sock = localhost == null ? SSLSocketFactory.getDefault().createSocket(host, port) : SSLSocketFactory.getDefault().createSocket(host, port, localhost, localport);
        }
        if (Globals.getPoodleFixEnabled()) {
            Globals.applyPoodleFix(sock, "BrokerLink");
        }
        return sock;
    }

    private static PortMapperEntry getRealRemotePort(BrokerAddressImpl remoteBroker) throws Exception {
        String version = String.valueOf(101) + "\n";
        PortMapperTable pt = new PortMapperTable();
        Socket s = new Socket(remoteBroker.getHost(), remoteBroker.getPort());
        InputStream is = s.getInputStream();
        OutputStream os = s.getOutputStream();
        try {
            os.write(version.getBytes());
            os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pt.read(is);
        is.close();
        os.close();
        s.close();
        return pt.get("cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createLink() {
        BrokerAddressImpl ba;
        block30: {
            if (DEBUG) {
                logger.log(4, "BrokerLink.createLink()");
            }
            this.brokerListLock.lock();
            ba = null;
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            if (!this.autoConnect) {
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return;
            }
            if (!this.connected) break block30;
            this.brokerListLock.unlock();
            return;
        }
        try {
            try {
                HashMap props = new HashMap();
                this.conn = BrokerLink.makeSocket(this.remote, this.parent, true, props);
                boolean ssl = props.get("ssl") != null;
                this.initNewConn(false, ssl);
                this.connected = true;
                ba = (BrokerAddressImpl)BrokerLink.consumeLinkInit(this.conn, this, this.parent, false);
            }
            catch (Exception e) {
                if (!this.connected) {
                    if (this.conn != null) {
                        try {
                            this.conn.close();
                        }
                        catch (Exception ssl) {
                            // empty catch block
                        }
                    }
                    if (this.writer != null) {
                        this.writer.shutdown();
                        this.writer = null;
                    }
                }
                if (this.createLinkFailures % 40L == 0L) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getName();
                    }
                    logger.log(16, "B2105", (Object)this.getRemoteString(), (Object)msg);
                    logger.logStack(4, "BrokerLink.createLink() failed", (Throwable)e);
                }
                ++this.createLinkFailures;
                Object object = this.linkInitWaitObject;
                // MONITORENTER : object
                if (!this.linkInitDone) {
                    this.linkInitDone = true;
                    this.linkInitWaitObject.notifyAll();
                }
                // MONITOREXIT : object
            }
            catch (OutOfMemoryError oom) {
                try {
                    if (this.conn != null) {
                        try {
                            this.conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.linkDown();
                }
                finally {
                    logger.log(16, this.oomStr);
                }
            }
            if (ba != null && !this.parent.addBroker(this.remote, this)) {
                this.closeConn();
            }
        }
        finally {
            this.brokerListLock.unlock();
        }
        if (!DEBUG) return;
        logger.log(4, "BrokerLink.createLink() finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object consumeLinkInit(Socket s, BrokerLink l, ClusterImpl cl, boolean allowNonLinkRequest) throws IOException {
        if (DEBUG) {
            logger.log(8, "BrokerLink.consumeLinkInit(" + allowNonLinkRequest + ")");
        }
        BrokerAddressImpl b = null;
        InputStream is = s.getInputStream();
        Packet p = new Packet();
        p.readPacket(is);
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && p.getPacketType() == 7 || ClusterManagerImpl.isDEBUG_CLUSTER_PACKET()) {
            logger.log(8, "RECEIVING PACKET : " + (l == null ? "from " + s.getInetAddress() : l) + "\nPacket = " + p);
        }
        if (p.getPacketType() != 4) {
            if (DEBUG) {
                logger.log(8, (l == null ? "Socket=" + s.getInetAddress() : "Link=" + l) + ", expect LINK_INIT but got:" + p.getPacketType());
            }
            s.close();
            return null;
        }
        LinkInfo li = null;
        try {
            li = ClusterImpl.processLinkInit(p);
            b = li.getAddress();
            if (l != null && b.getMQAddress().equals((Object)l.self.getMQAddress())) {
                Object[] args = new String[]{b.getHost().toString(), s.getInetAddress().toString(), l.self.toString() + " <---> " + b.toString()};
                throw new BrokerException(br.getString("B3099", args));
            }
            if (l != null && b.equals(l.self)) {
                Object[] args = new String[]{b.toShortString(), s.getInetAddress().toString(), l.self.toString() + " <---> " + b.toString()};
                logger.log(32, br.getKString("B3241", args));
                Broker.getBroker().exit(1, br.getString("B3241", args), BrokerEvent.Type.FATAL_ERROR, null, false, true, false);
                throw new BrokerException(br.getString("B3241", args));
            }
        }
        catch (BrokerException e) {
            logger.log(32, br.getKString("B3195", s.getInetAddress().toString()), (Throwable)e);
            if (l == null) {
                s.close();
            } else {
                l.shutdown();
            }
            return null;
        }
        catch (Exception e) {
            if (DEBUG) {
                logger.logStack(32, s.getInetAddress().toString(), (Throwable)e);
            }
            s.close();
            return null;
        }
        if (DEBUG) {
            logger.log(8, "Return from processLinkInit()");
        }
        if (!li.isLinkRequest()) {
            if (!allowNonLinkRequest) {
                logger.log(32, br.getKString("B3287", "LINK_INIT[" + li.getAddress().getClusterVersion() + "]", s.getInetAddress().toString()));
                if (l == null) {
                    s.close();
                } else {
                    l.shutdown();
                }
                return null;
            }
            return li;
        }
        if (l != null) {
            l.setRemote(b);
        }
        if (!cl.checkConfigServer(b)) {
            BrokerAddressImpl master = (BrokerAddressImpl)cl.getConfiguredConfigServer();
            if (master != null) {
                Integer lognum = (Integer)waitingMasterLogs.get((Object)b.getMQAddress());
                if (lognum == null || lognum % 30 == 0) {
                    logger.log(8, "B1251", (Object)b, (Object)master);
                } else {
                    logger.log(4, "B1251", (Object)b, (Object)master);
                }
                Hashtable hashtable = waitingMasterLogs;
                synchronized (hashtable) {
                    Integer num = (Integer)waitingMasterLogs.get((Object)b.getMQAddress());
                    if (num == null) {
                        waitingMasterLogs.put(b.getMQAddress(), 1);
                    } else {
                        waitingMasterLogs.put(b.getMQAddress(), num + 1);
                    }
                }
            } else {
                logger.log(32, "B3100", (Object)("No master broker. Closing cluster connection with " + b));
            }
            s.close();
            return null;
        }
        try {
            BrokerAddress mymaster = cl.getConfigServer();
            BrokerAddressImpl remotemaster = li.getConfigServer();
            if ((mymaster == null || remotemaster == null) && mymaster != remotemaster || mymaster != null && remotemaster != null && !mymaster.getMQAddress().equals((Object)remotemaster.getMQAddress())) {
                Object[] args = new String[]{b.toString(), mymaster == null ? "null" : mymaster.getMQAddress().toString(), remotemaster == null ? "null" : remotemaster.getMQAddress().toString()};
                logger.log(32, br.getKString("B3097", args));
                if (l == null) {
                    s.close();
                } else {
                    l.shutdown();
                }
                return null;
            }
        }
        catch (Exception e) {
            logger.logStack(4, e.getMessage() + (l == null ? "Socket " + s.getInetAddress() : "Link " + l), (Throwable)e);
            if (l == null) {
                s.close();
            } else {
                l.linkDown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(8, "remote.matchProps = " + li.getMatchProps());
            logger.log(8, "local.matchProps = " + cl.getMatchProps());
        }
        Properties remoteProps = li.getMatchProps();
        Properties myProps = cl.getMatchProps();
        String diff = BrokerLink.compareProps(myProps, remoteProps);
        if (diff != null) {
            logger.log(32, "B3098", (Object)b, (Object)diff);
            if (l == null) {
                s.close();
            } else {
                l.shutdown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(8, "BrokerLink.consumeLinkInit() finished");
        }
        assert (b != null);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean acceptConnection(BrokerAddressImpl remote, Socket remoteConn, boolean ssl) {
        block18: {
            if (DEBUG) {
                logger.log(4, "BrokerLink.acceptConnection()");
            }
            this.brokerListLock.lock();
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            this.setRemote(remote);
            if (this.connected) {
                if (DEBUG) {
                    logger.log(4, "Already connected!");
                }
                try {
                    remoteConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return bl;
            }
            if (this.parent.addBroker(remote, this)) break block18;
            try {
                remoteConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        this.conn = remoteConn;
        try {
            this.initNewConn(true, ssl);
        }
        catch (Exception e) {
            boolean bl = true;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        try {
            this.connected = true;
            // MONITOREXIT : brokerLink
            return true;
        }
        finally {
            this.brokerListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNewConn(boolean accepted, boolean ssl) throws IOException {
        Object s;
        if (DEBUG) {
            logger.log(4, "BrokerLink.initNewconn()");
        }
        if (ClusterManagerImpl.isDEBUG_CLUSTER_ALL() || ClusterManagerImpl.isDEBUG_CLUSTER_CONN()) {
            s = accepted ? "Accepted" : "Established";
            logger.log(8, "Connection " + (String)s + "\n\tRemote BrokerAddress = " + this.getRemoteString() + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        this.expectBrokerInfoPkt = true;
        s = this.handshakeLock;
        synchronized (s) {
            this.handshakeSent = false;
        }
        this.firstInfoSent = false;
        this.firstReceive = true;
        int inbufsize = this.parent.getTCPInputBufferSize();
        int outbufsize = this.parent.getTCPOutputBufferSize();
        if (ssl) {
            inbufsize = this.parent.getSSLInputBufferSize();
            outbufsize = this.parent.getSSLOutputBufferSize();
        }
        this.is = this.conn.getInputStream();
        if (inbufsize > 0) {
            this.is = new BufferedInputStream(this.is, inbufsize);
        }
        this.os = this.conn.getOutputStream();
        if (outbufsize > 0) {
            this.os = new BufferedOutputStream(this.os, outbufsize);
        }
        this.writer = new BrokerLinkWriter(this);
        this.writer.startWriterThread(this.os);
        Packet linkInitPkt = this.parent.getLinkInitPkt();
        Packet brokerInfoPkt = this.parent.getBrokerInfoPkt();
        if (DEBUG) {
            logger.log(2, "Cluster connection established: {0}", (Object)this);
        }
        this.sendPacket(linkInitPkt);
        this.sendPacket(brokerInfoPkt);
        this.parent.sendFlowControlUpdate(this.remote);
    }

    public void closeConn() {
        this.closeConn(false);
    }

    public void closeConn(boolean force) {
        this.closeConn(false, force);
    }

    protected void closeConn(boolean soft, boolean force) {
        if (DEBUG) {
            logger.log(4, "BrokerLink.closeConn()");
        }
        if (!this.connected && !this.autoConnect) {
            try {
                this.interrupt();
            }
            catch (Exception e) {
                logger.log(4, "BrokerLink.closeConn(): interrupt thread failed: " + e.getMessage());
            }
        }
        try {
            if (soft) {
                this.conn.shutdownOutput();
                return;
            }
            if (force) {
                this.conn.close();
                return;
            }
            if (!this.writer.isOutputShutdown()) {
                this.conn.close();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isOutputShutdown() {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isOutputShutdown();
    }

    public void shutdown() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.shutdown()");
        }
        this.autoConnect = false;
        this.closeConn();
    }

    private static String compareProps(Properties p1, Properties p2) {
        StringBuffer ret = new StringBuffer();
        Enumeration<?> e = p1.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String v1 = p1.getProperty(name);
            String v2 = p2.getProperty(name);
            if (v1 == null && v2 == null) continue;
            if (v1 == null && v2 != null || v2 == null && v1 != null) {
                ret.append("\t" + name + "=" + v1 + "," + v2 + "\n");
                continue;
            }
            if (v1.equals(v2)) continue;
            ret.append("\t" + name + "=" + v1 + "," + v2 + "\n");
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    private Packet tryReadPacket(boolean handleOom) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.tryReadPacket()");
        }
        Packet p = null;
        try {
            p = new Packet();
            p.readPacket(this.is);
            this.readActive = true;
        }
        catch (OutOfMemoryError oom) {
            if (!handleOom) {
                throw oom;
            }
            Globals.handleGlobalError(oom, br.getKString("B0019"));
            p = this.tryReadPacket(false);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeBrokerInfoPkt() throws Exception {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoPkt()");
        }
        this.expectBrokerInfoReplyPkt = false;
        Packet p = new Packet();
        p.readPacket(this.is);
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && p.getPacketType() == 7 || ClusterManagerImpl.isDEBUG_CLUSTER_PACKET()) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + p);
        }
        if (p.getPacketType() != 3) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO : " + p.getPacketType());
            this.conn.close();
            return;
        }
        BrokerInfo bi = (BrokerInfo)this.parent.receivePacket(this.remote, p, BrokerLink.getRealRemoteString(this.conn), this);
        if (bi == null) {
            logger.log(4, "Link = " + this + ", BROKER_INFO rejected");
            throw new IOException("BrokerInfo rejected");
        }
        this.expectBrokerInfoPkt = false;
        Integer v = bi.getClusterProtocolVersion();
        if (v != null && v >= 400) {
            BrokerAddress configServer = null;
            try {
                configServer = this.parent.getConfigServer();
            }
            catch (Exception e) {
                this.conn.close();
                logger.log(4, "Exception in getConfigServer: " + e.getMessage() + ", link " + this);
                return;
            }
            if (this.parent.waitForConfigSync() && !configServer.equals(bi.getBrokerAddr())) {
                if (ClusterManagerImpl.isDEBUG_CLUSTER_CONN() || ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || DEBUG) {
                    logger.log(8, "Waiting for sync with master broker " + configServer + ", Please retry  " + this);
                }
                this.conn.close();
                return;
            }
            ClusterBrokerInfoReply cbi = this.parent.getBrokerInfoReply(bi);
            GPacket gp = cbi.getGPacket();
            boolean shutdownOutput = cbi.sendAndClose();
            this.sendPacket(gp, shutdownOutput, false);
            this.expectBrokerInfoReplyPkt = true;
            if (shutdownOutput) {
                return;
            }
        }
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshakeSent = true;
        }
        object = this.linkInitWaitObject;
        synchronized (object) {
            if (this.parent.isConfigServerResolved()) {
                this.linkInitDone = true;
                this.linkInitWaitObject.notifyAll();
            }
        }
    }

    protected void handshakeSent() {
        this.handshakeSent = true;
    }

    private void consumeBrokerInfoReplyPkt() throws Exception {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoReplyPkt()");
        }
        GPacket gp = GPacket.getInstance();
        gp.read(this.is);
        if (gp.getType() != 46) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO_REPLY : " + gp.getType());
            this.conn.close();
            return;
        }
        this.parent.receivePacket(this.remote, gp, BrokerLink.getRealRemoteString(this.conn));
        gp = this.parent.getFirstInfoPacket();
        if (gp != null) {
            this.sendPacket(gp);
        }
    }

    private void consumePacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumePacket()");
        }
        Packet p = new Packet();
        try {
            p = this.tryReadPacket(true);
        }
        catch (OutOfMemoryError oom) {
            logger.log(32, "B3108");
            Broker broker = Broker.getBroker();
            Globals.getBrokerStateHandler();
            broker.exit(BrokerStateHandler.getRestartCode(), br.getString("B3108"), BrokerEvent.Type.ERROR);
        }
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && p.getPacketType() == 7 || ClusterManagerImpl.isDEBUG_CLUSTER_PACKET()) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + p);
        }
        try {
            this.parent.receivePacket(this.remote, p, BrokerLink.getRealRemoteString(this.conn), this);
        }
        catch (Exception e) {
            logger.logStack(32, "B2036", (Object)p, (Throwable)e);
        }
    }

    private void consumeGPacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeGPacket()");
        }
        GPacket gp = GPacket.getInstance();
        gp.read(this.is);
        this.readActive = true;
        if (ClusterManagerImpl.isDEBUG_CLUSTER_PACKET() || ClusterManagerImpl.isDEBUG_CLUSTER_PING() && (gp.getType() == 33 || gp.getType() == 34) || ClusterManagerImpl.isDEBUG_CLUSTER_ALL()) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + gp.toLongString());
            if (logger.getLevel() <= 4 && gp.getPayload() != null) {
                byte[] buf = gp.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump(buf, Integer.MAX_VALUE));
            }
        }
        if (this.firstReceive) {
            this.firstReceive = false;
            if (gp.getType() == 49) {
                this.parent.processFirstInfoPacket(gp, this);
                return;
            }
        }
        try {
            this.parent.receivePacket(this.remote, gp, null);
        }
        catch (Exception e) {
            logger.logStack(32, "B2036", (Object)gp, (Throwable)e);
        }
    }

    boolean isIOActive() {
        boolean writeActive = this.isWriteActive();
        return this.readActive || writeActive;
    }

    private boolean isWriteActive() {
        boolean writeActive = false;
        try {
            if (this.writer != null) {
                writeActive = this.writer.isWriteActive();
            }
        }
        catch (Exception e) {
            logger.log(1, "Ignoring exception on isIOActive", (Throwable)e);
        }
        return writeActive;
    }

    void enablePingLogging() {
        this.pingLogging.set(true);
    }

    void logIOActiveInPingInterval(int pingInterval) {
        if (this.pingLogging.get()) {
            logger.log(8, br.getKString("B1518", this + "[" + (this.readActive ? "r" : "") + (this.isWriteActive() ? "w" : "") + "]", String.valueOf(pingInterval) + " seconds"));
            this.pingLogging.set(false);
        }
    }

    protected void clearIOActiveFlag() {
        this.readActive = false;
        try {
            if (this.writer != null) {
                this.writer.clearWriteActiveFlag();
            }
        }
        catch (Exception e) {
            logger.log(1, "Ignoring exception on clearIOActiveFlag", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (!this.connected) {
                if (!this.autoConnect) break;
                this.createLink();
                if (this.connected) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                if (this.expectBrokerInfoPkt) {
                    if (DEBUG) {
                        logger.log(4, "Waiting for BROKER_INFO...");
                    }
                    this.consumeBrokerInfoPkt();
                    if (this.expectBrokerInfoReplyPkt) {
                        this.consumeBrokerInfoReplyPkt();
                    }
                    if (DEBUG) {
                        logger.log(4, "Received BROKER_INFO...");
                    }
                }
                try {
                    if (this.parent.useGPackets) {
                        this.consumeGPacket();
                        continue;
                    }
                    this.consumePacket();
                }
                catch (IOException e) {
                    logger.log(8, "IOException on link " + this);
                    this.linkDown(true);
                }
            }
            catch (OutOfMemoryError oom) {
                logger.log(32, "B3108");
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), br.getString("B3108"), BrokerEvent.Type.ERROR);
            }
            catch (Exception e) {
                logger.logStack(4, "Link Down " + this, (Throwable)e);
                this.linkDown();
            }
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            this.linkInitDone = true;
            this.linkInitWaitObject.notifyAll();
        }
        this.parent.handleBrokerLinkShutdown(this.remote);
    }

    @Override
    public String toString() {
        String clistener = this.parent.getServerSocketString();
        if (clistener == null) {
            return this.self.toString() + " <---> " + this.getRemoteString();
        }
        return this.self.toString() + "[" + clistener + "] <---> " + this.getRemoteString();
    }
}

