/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TransactionAcknowledgement
implements Externalizable {
    private transient Logger logger = Globals.getLogger();
    SysMessageID sysid = null;
    ConsumerUID iid = null;
    static final int MSG_PENDING = 0;
    static final int MSG_COMPLETE = 1;
    transient int state = 0;
    transient boolean shouldStore = true;
    ConsumerUID sid = null;

    public void setMsgComplete() {
        this.state = 1;
    }

    public boolean getMsgComplete() {
        return this.state == 1;
    }

    public TransactionAcknowledgement() {
    }

    public TransactionAcknowledgement(SysMessageID sysid, ConsumerUID iid, ConsumerUID sid) {
        this.sysid = sysid;
        this.iid = iid;
        this.sid = sid;
    }

    public boolean shouldStore() {
        return this.shouldStore;
    }

    public void setShouldStore(boolean b) {
        this.shouldStore = b;
    }

    public ConsumerUID getConsumerUID() {
        return this.iid;
    }

    public ConsumerUID getStoredConsumerUID() {
        return this.sid;
    }

    public SysMessageID getSysMessageID() {
        return this.sysid;
    }

    public int hashCode() {
        return this.sysid.hashCode() + this.iid.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TransactionAcknowledgement) {
            TransactionAcknowledgement that = (TransactionAcknowledgement)o;
            if (this.sysid.equals((Object)that.sysid) && this.iid.equals(that.iid)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[" + this.sysid.toString() + "]" + this.iid.toString() + ":" + this.sid.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.sysid.writeID((DataOutput)out);
        out.writeObject(this.iid);
        out.writeObject(this.sid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sysid = new SysMessageID();
        this.sysid.readID((DataInput)in);
        this.iid = (ConsumerUID)in.readObject();
        try {
            this.sid = (ConsumerUID)in.readObject();
        }
        catch (Exception ex) {
            this.logger.log(4, "TransactionAcknowledgement.readExternal(): old transaction format");
            this.sid = this.iid;
        }
    }
}

