/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ProducerSpi;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.PartitionNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Producer
extends ProducerSpi {
    transient Set destinations = null;
    private transient DestinationList DL = Globals.getDestinationList();
    private transient PartitionedStore pstore = null;

    private Producer(ConnectionUID cuid, DestinationUID duid, String id, PartitionedStore ps) {
        super(cuid, duid, id);
        this.pstore = ps;
    }

    public static Producer createProducer(DestinationUID duid, ConnectionUID cuid, String id, PartitionedStore ps) {
        Producer producer = new Producer(cuid, duid, id, ps);
        Producer old = allProducers.put(producer.getProducerUID(), producer);
        if (duid.isWildcard()) {
            wildcardProducers.add(producer.getProducerUID());
        }
        assert (old == null) : old;
        return producer;
    }

    @Override
    public void destroyProducer() {
        if (this.getDestinationUID().isWildcard()) {
            wildcardProducers.remove((Object)this.getProducerUID());
            List[] dss = null;
            try {
                dss = DestinationList.findMatchingIDs(this.pstore, this.getDestinationUID());
            }
            catch (PartitionNotFoundException e) {
                if (DEBUG) {
                    this.logger.log(8, "Producer.destroyProducer on " + this.getDestinationUID() + ": " + e.getMessage());
                }
                dss = new List[]{new ArrayList()};
            }
            List duids = dss[0];
            for (DestinationUID duid : duids) {
                Destination[] dd = DestinationList.getDestination(this.pstore, duid);
                Destination d = dd[0];
                if (d == null) continue;
                d.removeProducer(this.uid);
            }
        } else {
            Destination[] dd = DestinationList.getDestination(this.pstore, this.getDestinationUID());
            Destination d = dd[0];
            if (d != null) {
                d.removeProducer(this.uid);
            }
        }
        this.destroy();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.lastResumeFlowSizes.clear();
    }

    @Override
    public boolean isWildcard() {
        return this.destination_uid.isWildcard();
    }

    @Override
    public Set getDestinations() {
        if (this.destinations == null) {
            this.destinations = new HashSet();
            if (!this.destination_uid.isWildcard()) {
                this.destinations.add(this.destination_uid);
            } else {
                List[] ll = null;
                try {
                    ll = DestinationList.findMatchingIDs(this.pstore, this.destination_uid);
                }
                catch (PartitionNotFoundException e) {
                    if (DEBUG) {
                        this.logger.log(8, "Producer.getDestinations() on " + this.getDestinationUID() + ": " + e.getMessage());
                    }
                    ll = new List[]{new ArrayList()};
                }
                List l = ll[0];
                for (DestinationUID duid : l) {
                    this.destinations.add(duid);
                }
            }
        }
        return this.destinations;
    }
}

