/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.util.Arrays;
import java.util.Random;

public class UniqueID {
    static final int PREFIX_BITS = 16;
    static final int TIMESTAMP_BITS = 40;
    static final int COUNTER_BITS = 8;
    static final long MAX_SLEEP_SHIFT = 7000L;
    static long max_sleep_shift = 7000L;
    static final long WRAP_TIME = 0xFFFFFFFFFFL;
    static final long TIMESTAMP_MASK = 0xFFFFFFFFFFL;
    static final int MAX_COUNTER = 255;
    static long last_timestamp = 0L;
    static short counter = 0;
    static long counter_wraps = 0L;
    static long timestamp_advances = 0L;
    static long timestamp_delays = 0L;

    public static long generateID() {
        return UniqueID.generateID((short)0);
    }

    public static synchronized long generateID(short prefix) {
        long id = 0L;
        long curr_timestamp = System.currentTimeMillis();
        if (curr_timestamp > last_timestamp) {
            last_timestamp = curr_timestamp;
            counter = 0;
        } else if (curr_timestamp < last_timestamp) {
            long delta = last_timestamp - curr_timestamp;
            if (delta <= max_sleep_shift) {
                while (curr_timestamp <= last_timestamp) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(last_timestamp - curr_timestamp);
                        ++timestamp_delays;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    curr_timestamp = System.currentTimeMillis();
                }
            } else {
                curr_timestamp = last_timestamp + 1L;
                if (++timestamp_advances % 200L == 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            last_timestamp = curr_timestamp;
            counter = 0;
        } else if (counter < 255) {
            counter = (short)(counter + 1);
        } else {
            counter = 0;
            ++counter_wraps;
            while (curr_timestamp <= last_timestamp) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                curr_timestamp = System.currentTimeMillis();
            }
            last_timestamp = curr_timestamp;
        }
        id = prefix;
        id <<= 48;
        curr_timestamp = (curr_timestamp & 0xFFFFFFFFFFL) << 8;
        id |= curr_timestamp;
        if ((id |= (long)counter) == 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            id = UniqueID.generateID(prefix);
        }
        return id;
    }

    public static long age(long id) {
        return UniqueID.age(id, System.currentTimeMillis());
    }

    public static long age(long id, long currentTime) {
        long curr_time = currentTime;
        long id_time = UniqueID.getTimestamp(id);
        if ((curr_time &= 0xFFFFFFFFFFL) > id_time) {
            return curr_time - id_time;
        }
        return curr_time + (0xFFFFFFFFFFL - id_time);
    }

    public static String toString(long id) {
        return UniqueID.getPrefix(id) + "_" + UniqueID.getTimestamp(id) + "_" + UniqueID.getCounter(id);
    }

    public static String toShortString(long id) {
        return String.valueOf(UniqueID.getPrefix(id)) + String.valueOf(UniqueID.getTimestamp(id)) + String.valueOf(UniqueID.getCounter(id));
    }

    public static void setMaxSleepShift(long n) {
        max_sleep_shift = n;
    }

    public static synchronized String toLongString(long id) {
        return "ID:" + UniqueID.toString(id) + "\n       PREFIX_BITS = " + 16 + "\n    TIMESTAMP_BITS = " + 40 + "\n      COUNTER_BITS = " + 8 + "\n    TIMESTAMP_MASK = " + Long.toHexString(0xFFFFFFFFFFL) + "\n       MAX_COUNTER = " + 255 + "\n   max_sleep_shift = " + max_sleep_shift + "\n    last_timestamp = " + last_timestamp + "\n           counter = " + counter + "\n     counter_wraps = " + counter_wraps + "\ntimestamp_advances = " + timestamp_advances + "\n  timestamp_delays = " + timestamp_delays;
    }

    public static int hashCode(long id) {
        return (int)(id ^ id >>> 32);
    }

    public static synchronized boolean diagnostic(int iter, short prefix) {
        System.out.println("----- UniqueID diagnostics -----");
        System.out.println("Generating one ID. prefix = " + prefix);
        counter_wraps = 0L;
        timestamp_advances = 0L;
        timestamp_delays = 0L;
        boolean passed = true;
        long start_time = System.currentTimeMillis();
        long id = UniqueID.generateID(prefix);
        System.out.println(" ID:" + id + " (" + UniqueID.toString(id) + ")");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long stop_time = System.currentTimeMillis();
        System.out.println("Age:" + UniqueID.age(id) + " ms (should be  ~" + (stop_time - start_time) + " ms)");
        if (prefix == UniqueID.getPrefix(id)) {
            System.out.println("Prefix=" + prefix + "=" + UniqueID.getPrefix(id));
        } else {
            System.out.println("ERROR! Prefix=" + prefix + "!=" + UniqueID.getPrefix(id));
            passed = false;
        }
        if ((last_timestamp & 0xFFFFFFFFFFL) == UniqueID.getTimestamp(id)) {
            System.out.println("Timestamp=" + (last_timestamp & 0xFFFFFFFFFFL) + "=" + UniqueID.getTimestamp(id));
        } else {
            System.out.println("ERROR! Timestamp=" + (last_timestamp & 0xFFFFFFFFFFL) + "!=" + UniqueID.getTimestamp(id));
            passed = false;
        }
        if (counter == UniqueID.getCounter(id)) {
            System.out.println("Counter=" + counter + "=" + UniqueID.getCounter(id));
        } else {
            System.out.println("ERROR! Counter=" + counter + "!=" + UniqueID.getCounter(id));
            passed = false;
        }
        long[] idarray = new long[iter];
        System.out.println("Generating " + iter + " IDs...");
        long start = System.currentTimeMillis();
        for (int n = 0; n < iter; ++n) {
            idarray[n] = UniqueID.generateID(prefix);
        }
        long stop = System.currentTimeMillis();
        System.out.println("Called getID() " + iter + " times in " + (stop - start) + " ms (" + (float)iter / (float)(stop - start) * 1000.0f + " ids per second)");
        System.out.println(UniqueID.toLongString(0L));
        System.out.println("Sorting ids...");
        Arrays.sort(idarray);
        long last_id = 0L;
        System.out.println("Checking ids for dups...");
        int ndups = 0;
        for (int n = 0; n < iter; ++n) {
            if (idarray[n] == last_id) {
                System.out.println("ERROR! Duplicate ID: " + last_id);
                ++ndups;
                passed = false;
            }
            if (idarray[n] == 0L) {
                System.out.println("ERROR! Zero ID: " + idarray[n]);
                passed = false;
            }
            last_id = idarray[n];
        }
        if (ndups == 0) {
            System.out.println("Passed -- no duplicates detected");
        }
        System.out.println("Done");
        return passed;
    }

    public static long getTimestamp(long id) {
        return id >>> 8 & 0xFFFFFFFFFFL;
    }

    public static short getPrefix(long id) {
        return (short)(id >>> 48);
    }

    private static short getCounter(long id) {
        return (short)(id & 0xFFL);
    }

    public static void main(String[] args) {
        int iter = 10000;
        Random rand = new Random();
        int prefix = rand.nextInt();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                iter = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-p")) {
                prefix = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("-n <itertions>  -p <prefix>");
            System.exit(1);
        }
        System.out.println("Starting UID test...");
        boolean passed = UniqueID.diagnostic(iter, (short)prefix);
        if (passed) {
            System.out.println("PASSED");
            System.exit(0);
        } else {
            System.out.println("FALIED");
            System.exit(1);
        }
    }
}

