/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SupportUtil {
    public static Hashtable getAllStackTracesAsMap() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            Method m = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.entrySet().iterator();
            Map.Entry me = null;
            String retstr = "";
            while (itr.hasNext()) {
                me = itr.next();
                Thread thr = (Thread)me.getKey();
                StackTraceElement[] stes = (StackTraceElement[])me.getValue();
                String name = thr + " 0x" + Long.toHexString(thr.hashCode());
                Vector<String> value = new Vector<String>();
                for (int i = 0; i < stes.length; ++i) {
                    value.add(stes[i].toString());
                }
                ht.put(name, value);
            }
        }
        catch (Throwable thr) {
            ht.put("error", "Can not getStackTrace " + thr);
        }
        return ht;
    }

    public static String getAllStackTraces(String prefix) {
        try {
            Method m = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.entrySet().iterator();
            Map.Entry me = null;
            StringBuffer retstr = new StringBuffer();
            while (itr.hasNext()) {
                me = itr.next();
                Thread thr = (Thread)me.getKey();
                StackTraceElement[] stes = (StackTraceElement[])me.getValue();
                retstr.append(prefix + thr + " 0x" + Long.toHexString(thr.hashCode()) + "\n");
                for (int i = 0; i < stes.length; ++i) {
                    retstr.append(prefix + "\t" + stes[i] + "\n");
                }
                retstr.append("\n");
            }
            return retstr.toString();
        }
        catch (Throwable thr) {
            return prefix + "Can not getStackTrace " + thr;
        }
    }

    public static String getStackTrace(String prefix) {
        Thread thr = Thread.currentThread();
        try {
            Method m = Thread.class.getMethod("getStackTrace", new Class[0]);
            StackTraceElement[] stes = (StackTraceElement[])m.invoke((Object)thr, new Object[0]);
            StringBuffer retstr = new StringBuffer();
            retstr.append(prefix + thr + " 0x" + Long.toHexString(thr.hashCode()) + "\n");
            for (int i = 0; i < stes.length; ++i) {
                retstr.append(prefix + "\t" + stes[i] + "\n");
            }
            return retstr.toString();
        }
        catch (Throwable t) {
            return prefix + "Can not getStackTrace " + t;
        }
    }

    public static String getStackTraceString(Throwable e) {
        String str = null;
        try {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            str = sw.toString();
        }
        catch (Throwable t) {
            str = e.toString();
        }
        return str;
    }
}

